/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.extensions;

import android.graphics.Matrix;
import androidx.core.util.Pools;
import com.aureusapps.android.extensions.FloatExtensionsKt;
import com.aureusapps.android.extensions.MatrixComponents;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0016\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0012J&\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J\u001e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012J.\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J\u001e\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J.\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/aureusapps/android/extensions/MatrixUtils;", "", "()V", "matrixArrayPool", "Landroidx/core/util/Pools$SynchronizedPool;", "", "pointArrayPool", "acquireMatrixArray", "acquirePointArray", "combineComponents", "", "matrix", "Landroid/graphics/Matrix;", "components", "Lcom/aureusapps/android/extensions/MatrixComponents;", "decomposeComponents", "pivot", "Lkotlin/Pair;", "", "getRotation", "px", "py", "getScaling", "getTranslation", "releaseMatrixArray", "array", "releasePointArray", "setRotation", "degrees", "setScaling", "sx", "sy", "setTranslation", "tx", "ty", "extensions_release"})
public final class MatrixUtils {
    @NotNull
    public static final MatrixUtils INSTANCE = new MatrixUtils();
    @NotNull
    private static final Pools.SynchronizedPool<float[]> matrixArrayPool = new Pools.SynchronizedPool(100);
    @NotNull
    private static final Pools.SynchronizedPool<float[]> pointArrayPool = new Pools.SynchronizedPool(100);

    private MatrixUtils() {
    }

    private final float[] acquireMatrixArray() {
        float[] fArray = (float[])matrixArrayPool.acquire();
        if (fArray == null) {
            fArray = new float[9];
        }
        return fArray;
    }

    private final void releaseMatrixArray(float[] array) {
        matrixArrayPool.release((Object)array);
    }

    private final float[] acquirePointArray() {
        float[] fArray = (float[])pointArrayPool.acquire();
        if (fArray == null) {
            fArray = new float[2];
        }
        return fArray;
    }

    private final void releasePointArray(float[] array) {
        pointArrayPool.release((Object)array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<Float, Float> getTranslation(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            Pair pair = TuplesKt.to((Object)Float.valueOf(matrixArray[2]), (Object)Float.valueOf(matrixArray[5]));
            return pair;
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTranslation(@NotNull Matrix matrix, float tx, float ty) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        matrix.getValues(matrixArray);
        matrixArray[2] = tx;
        matrixArray[5] = ty;
        matrix.setValues(matrixArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<Float, Float> getTranslation(@NotNull Matrix matrix, float px, float py) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] pointArray = this.acquirePointArray();
        try {
            pointArray[0] = px;
            pointArray[1] = py;
            matrix.mapPoints(pointArray);
            Pair pair = TuplesKt.to((Object)Float.valueOf(pointArray[0] - px), (Object)Float.valueOf(pointArray[1] - py));
            return pair;
        }
        finally {
            this.releasePointArray(pointArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTranslation(@NotNull Matrix matrix, float tx, float ty, float px, float py) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] pointArray = this.acquirePointArray();
        float[] matrixArray = this.acquireMatrixArray();
        try {
            pointArray[0] = px;
            pointArray[1] = py;
            matrix.mapPoints(pointArray);
            matrix.getValues(matrixArray);
            matrixArray[2] = matrixArray[2] + (tx - pointArray[0] + px);
            matrixArray[5] = matrixArray[5] + (ty - pointArray[1] + py);
            matrix.setValues(matrixArray);
        }
        finally {
            this.releasePointArray(pointArray);
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getRotation(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float f = FloatExtensionsKt.toDegrees((float)Math.atan2(matrixArray[3], matrixArray[0]));
            return f;
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRotation(@NotNull Matrix matrix, float degrees) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float sx = (float)Math.sqrt(matrixArray[0] * matrixArray[0] + matrixArray[3] * matrixArray[3]);
            float sy = (float)Math.sqrt(matrixArray[1] * matrixArray[1] + matrixArray[4] * matrixArray[4]);
            float rad = FloatExtensionsKt.toRadians(degrees);
            matrixArray[0] = sx * (float)Math.cos(rad);
            matrixArray[1] = -sy * (float)Math.sin(rad);
            matrixArray[3] = sx * (float)Math.sin(rad);
            matrixArray[4] = sy * (float)Math.cos(rad);
            matrix.setValues(matrixArray);
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getRotation(@NotNull Matrix matrix, float px, float py) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float f = FloatExtensionsKt.toDegrees((float)Math.atan2(matrixArray[3] - py * matrixArray[6], matrixArray[0] - px * matrixArray[6]));
            return f;
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRotation(@NotNull Matrix matrix, float degrees, float px, float py) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float cr = FloatExtensionsKt.toDegrees((float)Math.atan2(matrixArray[3] - py * matrixArray[6], matrixArray[0] - px * matrixArray[6]));
            matrix.postRotate(degrees - cr, px, py);
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<Float, Float> getScaling(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float sx = (float)Math.sqrt(matrixArray[0] * matrixArray[0] + matrixArray[3] * matrixArray[3]);
            float sy = (float)Math.sqrt(matrixArray[1] * matrixArray[1] + matrixArray[4] * matrixArray[4]);
            Pair pair = TuplesKt.to((Object)Float.valueOf(sx), (Object)Float.valueOf(sy));
            return pair;
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setScaling(@NotNull Matrix matrix, float sx, float sy) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float cr = FloatExtensionsKt.toDegrees((float)Math.atan2(matrixArray[3], matrixArray[0]));
            matrixArray[0] = sx * (float)Math.cos(cr);
            matrixArray[1] = -sy * (float)Math.sin(cr);
            matrixArray[3] = sx * (float)Math.sin(cr);
            matrixArray[4] = sy * (float)Math.cos(cr);
            matrix.setValues(matrixArray);
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<Float, Float> getScaling(@NotNull Matrix matrix, float px, float py) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float a = matrixArray[0] - px * matrixArray[6];
            float b = matrixArray[1] - px * matrixArray[7];
            float d = matrixArray[3] - py * matrixArray[6];
            float e = matrixArray[4] - py * matrixArray[7];
            float sx = (float)Math.sqrt(a * a + d * d);
            float sy = (float)Math.sqrt(b * b + e * e);
            Pair pair = TuplesKt.to((Object)Float.valueOf(sx), (Object)Float.valueOf(sy));
            return pair;
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setScaling(@NotNull Matrix matrix, float sx, float sy, float px, float py) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float a = matrixArray[0] - px * matrixArray[6];
            float b = matrixArray[1] - px * matrixArray[7];
            float d = matrixArray[3] - py * matrixArray[6];
            float e = matrixArray[4] - py * matrixArray[7];
            float csx = (float)Math.sqrt(a * a + d * d);
            float csy = (float)Math.sqrt(b * b + e * e);
            matrix.postScale(sx / csx, sy / csy, px, py);
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MatrixComponents decomposeComponents(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = this.acquireMatrixArray();
        try {
            matrix.getValues(matrixArray);
            float sx = (float)Math.sqrt(matrixArray[0] * matrixArray[0] + matrixArray[3] * matrixArray[3]);
            float sy = (float)Math.sqrt(matrixArray[1] * matrixArray[1] + matrixArray[4] * matrixArray[4]);
            float r = FloatExtensionsKt.toDegrees((float)Math.atan2(matrixArray[3], matrixArray[0]));
            float tx = matrixArray[2];
            float ty = matrixArray[5];
            MatrixComponents matrixComponents = new MatrixComponents((Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(sx), (Object)Float.valueOf(sy)), r, (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(tx), (Object)Float.valueOf(ty)), (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
            return matrixComponents;
        }
        finally {
            this.releaseMatrixArray(matrixArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MatrixComponents decomposeComponents(@NotNull Matrix matrix, @NotNull Pair<Float, Float> pivot) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter(pivot, (String)"pivot");
        float[] matrixArray = this.acquireMatrixArray();
        float[] pointArray = this.acquirePointArray();
        try {
            matrix.getValues(matrixArray);
            float px = ((Number)pivot.component1()).floatValue();
            float py = ((Number)pivot.component2()).floatValue();
            float a = matrixArray[0] - px * matrixArray[6];
            float b = matrixArray[1] - px * matrixArray[7];
            float d = matrixArray[3] - py * matrixArray[6];
            float e = matrixArray[4] - py * matrixArray[7];
            float sx = (float)Math.sqrt(a * a + d * d);
            float sy = (float)Math.sqrt(b * b + e * e);
            float r = FloatExtensionsKt.toDegrees((float)Math.atan2(matrixArray[3] - py * matrixArray[6], matrixArray[0] - px * matrixArray[6]));
            pointArray[0] = px;
            pointArray[1] = py;
            matrix.mapPoints(pointArray);
            float tx = pointArray[0] - px;
            float ty = pointArray[1] - py;
            MatrixComponents matrixComponents = new MatrixComponents((Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(sx), (Object)Float.valueOf(sy)), r, (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(tx), (Object)Float.valueOf(ty)), (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(px), (Object)Float.valueOf(py)));
            return matrixComponents;
        }
        finally {
            this.releaseMatrixArray(matrixArray);
            this.releasePointArray(pointArray);
        }
    }

    public final void combineComponents(@NotNull Matrix matrix, @NotNull MatrixComponents components) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        matrix.reset();
        Pair<Float, Float> pair = components.getScaling();
        float sx = ((Number)pair.component1()).floatValue();
        float sy = ((Number)pair.component2()).floatValue();
        float r = components.getRotation();
        Pair<Float, Float> pair2 = components.getTranslation();
        float tx = ((Number)pair2.component1()).floatValue();
        float ty = ((Number)pair2.component2()).floatValue();
        Pair<Float, Float> pair3 = components.getPivot();
        float px = ((Number)pair3.component1()).floatValue();
        float py = ((Number)pair3.component2()).floatValue();
        matrix.postScale(sx, sy, px, py);
        matrix.postRotate(r, px, py);
        this.setTranslation(matrix, tx, ty, px, py);
    }
}

