/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.extensions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import androidx.documentfile.provider.DocumentFile;
import com.aureusapps.android.extensions.InputStreamExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0007\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a$\u0010\r\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u001a\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\f\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\f*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\f\u001a\u0012\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0018*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\u001f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001cH\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\u00a8\u0006!"}, d2={"isFileUri", "", "Landroid/net/Uri;", "(Landroid/net/Uri;)Z", "isTreeUri", "copyTo", "", "context", "Landroid/content/Context;", "dstUri", "createDirectory", "dirName", "", "createFile", "displayName", "mimeType", "delete", "exists", "fileExists", "fileName", "findFile", "isDirectory", "isEmpty", "listFiles", "", "openInputStream", "Ljava/io/InputStream;", "readBytes", "", "readToBuffer", "Ljava/nio/ByteBuffer;", "writeBytes", "bytes", "extensions_release"})
@SourceDebugExtension(value={"SMAP\nUriExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriExtensions.kt\ncom/aureusapps/android/extensions/UriExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,562:1\n1#2:563\n11335#3:564\n11670#3,2:565\n11672#3:568\n11335#3:569\n11670#3,3:570\n1282#3,2:575\n36#4:567\n36#4:573\n36#4:574\n36#4:577\n*S KotlinDebug\n*F\n+ 1 UriExtensions.kt\ncom/aureusapps/android/extensions/UriExtensionsKt\n*L\n131#1:564\n131#1:565,2\n131#1:568\n137#1:569\n137#1:570,3\n367#1:575,2\n131#1:567\n187#1:573\n221#1:574\n368#1:577\n*E\n"})
public final class UriExtensionsKt {
    public static final boolean isTreeUri(@NotNull Uri $this$isTreeUri) {
        Intrinsics.checkNotNullParameter((Object)$this$isTreeUri, (String)"<this>");
        List paths = $this$isTreeUri.getPathSegments();
        return paths.size() >= 2 && Intrinsics.areEqual((Object)"tree", paths.get(0));
    }

    public static final boolean isFileUri(@NotNull Uri $this$isFileUri) {
        Intrinsics.checkNotNullParameter((Object)$this$isFileUri, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isFileUri.getScheme(), (Object)"file");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"DiscouragedApi"})
    @Nullable
    public static final String fileName(@NotNull Uri $this$fileName, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$fileName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String fileName = null;
        try {
            String string;
            String string2;
            block13: {
                String string3 = $this$fileName.getScheme();
                if (string3 == null) return fileName;
                switch (string3.hashCode()) {
                    case 3143036: {
                        if (string3.equals("file")) return $this$fileName.getLastPathSegment();
                        return fileName;
                    }
                    case -368816979: {
                        if (string3.equals("android.resource")) break;
                        return fileName;
                    }
                    case 3213448: {
                        if (!string3.equals("http")) {
                            return fileName;
                        }
                        break block13;
                    }
                    case 99617003: {
                        if (!string3.equals("https")) {
                            return fileName;
                        }
                        break block13;
                    }
                    case 951530617: {
                        if (!string3.equals("content")) return fileName;
                        DocumentFile documentFile = DocumentFile.fromSingleUri((Context)context, (Uri)$this$fileName);
                        if (documentFile == null) return null;
                        String string4 = documentFile.getName();
                        return string4;
                    }
                }
                List segments = $this$fileName.getPathSegments();
                if (segments.size() < 1) return fileName;
                Intrinsics.checkNotNullExpressionValue((Object)segments, (String)"segments");
                String lastSegment = (String)CollectionsKt.last((List)segments);
                if (TextUtils.isDigitsOnly((CharSequence)lastSegment)) {
                    Resources resources = context.getResources();
                    Intrinsics.checkNotNullExpressionValue((Object)lastSegment, (String)"lastSegment");
                    return resources.getResourceEntryName(Integer.parseInt(lastSegment));
                }
                if (segments.size() < 2) return fileName;
                return lastSegment;
            }
            fileName = (string2 = $this$fileName.getPath()) != null && (string = StringsKt.substringAfterLast$default((String)string2, (String)"/", null, (int)2, null)) != null ? StringsKt.substringBefore$default((String)string, (String)"?", null, (int)2, null) : null;
            return fileName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileName;
    }

    public static final boolean isDirectory(@NotNull Uri $this$isDirectory, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean result = false;
        try {
            if (UriExtensionsKt.isFileUri($this$isDirectory)) {
                boolean bl;
                String string = $this$isDirectory.getPath();
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    bl = new File(it).isDirectory();
                } else {
                    bl = false;
                }
                result = bl;
            } else if (UriExtensionsKt.isTreeUri($this$isDirectory)) {
                DocumentFile documentFile = DocumentFile.fromTreeUri((Context)context, (Uri)$this$isDirectory);
                result = documentFile != null ? documentFile.isDirectory() : false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final List<Uri> listFiles(@NotNull Uri $this$listFiles, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$listFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List uriList = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (UriExtensionsKt.isFileUri($this$listFiles)) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                String string = $this$listFiles.getPath();
                if (string == null) return null;
                File[] it = string;
                boolean bl = false;
                File[] it2 = it = new File((String)it);
                boolean bl2 = false;
                if (!it2.isDirectory()) return null;
                File[] fileArray = it;
                File[] fileArray2 = fileArray;
                if (fileArray2 == null) return null;
                it = fileArray2.listFiles();
                if (it == null) return null;
                it2 = it;
                boolean $i$f$map = false;
                void var9_15 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv2).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv2).length;
                for (int i = 0; i < n; ++i) {
                    void it3;
                    void item$iv$iv;
                    void var15_27 = item$iv$iv = $this$mapTo$iv$iv2[i];
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
                    void $this$toUri$iv = it3;
                    boolean $i$f$toUri = false;
                    Uri uri = Uri.fromFile((File)$this$toUri$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(this)");
                    collection.add(uri);
                }
                List list = (List)destination$iv$iv;
                return list;
            }
            if (!UriExtensionsKt.isTreeUri($this$listFiles)) return uriList;
            DocumentFile documentFile = DocumentFile.fromTreeUri((Context)context, (Uri)$this$listFiles);
            if (documentFile == null) return null;
            DocumentFile[] documentFileArray = documentFile.listFiles();
            if (documentFileArray == null) return null;
            DocumentFile[] documentFileArray2 = documentFileArray;
            boolean $i$f$map = false;
            void $this$map$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var13_24 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUri());
            }
            List list = (List)destination$iv$iv;
            return list;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uriList;
    }

    public static final boolean isEmpty(@NotNull Uri $this$isEmpty, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean empty = false;
        try {
            List<Uri> list;
            List<Uri> list2 = list = UriExtensionsKt.listFiles($this$isEmpty, context);
            empty = list2 != null ? list2.isEmpty() : false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return empty;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Uri createFile(@NotNull Uri $this$createFile, @NotNull Context context, @NotNull String displayName, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Uri fileUri = null;
        try {
            if (UriExtensionsKt.isFileUri($this$createFile)) {
                void $this$toUri$iv;
                File file;
                String string = $this$createFile.getPath();
                if (string == null) return null;
                String it = string;
                boolean bl = false;
                File it2 = file = new File(it);
                boolean bl2 = false;
                if (!it2.isDirectory()) return null;
                File file2 = file;
                File file3 = file2;
                if (file3 == null) return null;
                File it3 = file3;
                boolean bl3 = false;
                it2 = new File(it3, displayName);
                boolean $i$f$toUri = false;
                Uri uri = Uri.fromFile((File)$this$toUri$iv);
                Uri uri2 = uri;
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(this)");
                return uri2;
            }
            if (!UriExtensionsKt.isTreeUri($this$createFile)) return fileUri;
            DocumentFile documentFile = DocumentFile.fromTreeUri((Context)context, (Uri)$this$createFile);
            if (documentFile == null) return null;
            DocumentFile documentFile2 = documentFile.createFile(mimeType, displayName);
            if (documentFile2 == null) return null;
            Uri uri = documentFile2.getUri();
            return uri;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileUri;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final Uri createDirectory(@NotNull Uri $this$createDirectory, @NotNull Context context, @NotNull String dirName) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
            dirUri = null;
            try {
                block9: {
                    if (!UriExtensionsKt.isFileUri($this$createDirectory)) break block9;
                    var4_4 = $this$createDirectory.getPath();
                    if (var4_4 == null) ** GOTO lbl-1000
                    it = var4_4;
                    $i$a$-let-UriExtensionsKt$createDirectory$1 = false;
                    it = it = new File((String)it, dirName);
                    $i$a$-takeIf-UriExtensionsKt$createDirectory$2 = false;
                    v0 = var6_17 = (it.isDirectory() != false || it.mkdir() != false) != false ? it : null;
                    if (var6_17 != null) {
                        it = var6_17;
                        $i$f$toUri = false;
                        v1 = Uri.fromFile((File)$this$toUri$iv);
                        v2 = v1;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"fromFile(this)");
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = null;
                    }
                    dirUri = v2;
                    break block8;
                }
                if (!UriExtensionsKt.isTreeUri($this$createDirectory)) break block8;
                var5_19 = DocumentFile.fromTreeUri((Context)context, (Uri)$this$createDirectory);
                if (var5_19 != null) {
                    it = var6_18 = var5_19;
                    $i$a$-takeIf-UriExtensionsKt$createDirectory$root$1 = false;
                    v3 /* !! */  = it.isDirectory() ? var6_18 : null;
                } else {
                    v3 /* !! */  = root = null;
                }
                if (root == null || (var5_19 = root.findFile(dirName)) == null) ** GOTO lbl-1000
                it = var7_8 = var5_19;
                $i$a$-takeIf-UriExtensionsKt$createDirectory$3 = false;
                v4 /* !! */  = var6_18 = it.isDirectory() != false ? var7_8 : null;
                if (var6_18 != null && (var7_8 = var6_18.getUri()) != null) {
                    v5 = var7_8;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = root != null && (var8_14 = root.createDirectory(dirName)) != null ? var8_14.getUri() : null;
                }
                dirUri = v5;
            }
            catch (Exception var4_6) {
                // empty catch block
            }
        }
        return dirUri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"DiscouragedApi"})
    public static final boolean exists(@NotNull Uri $this$exists, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean exists = false;
        try {
            String string = $this$exists.getScheme();
            if (string == null) throw new Exception("Unknown Uri scheme");
            int n = -1;
            switch (string.hashCode()) {
                case 3143036: {
                    if (string.equals("file")) {
                        n = 1;
                    }
                    break;
                }
                case 3568542: {
                    if (string.equals("tree")) {
                        n = 2;
                    }
                    break;
                }
                case -368816979: {
                    if (string.equals("android.resource")) {
                        n = 3;
                    }
                    break;
                }
                case 3213448: {
                    if (string.equals("http")) {
                        n = 4;
                    }
                    break;
                }
                case 99617003: {
                    if (string.equals("https")) {
                        n = 4;
                    }
                    break;
                }
                case 951530617: {
                    if (string.equals("content")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    String string2 = $this$exists.getPath();
                    if (string2 == null) return false;
                    String it = string2;
                    boolean bl = false;
                    boolean bl2 = new File(it).exists();
                    return bl2;
                }
                case 5: {
                    DocumentFile documentFile = DocumentFile.fromSingleUri((Context)context, (Uri)$this$exists);
                    if (documentFile == null) return false;
                    boolean bl = documentFile.exists();
                    return bl;
                }
                case 3: {
                    List segments = $this$exists.getPathSegments();
                    if (segments.size() < 1) return exists;
                    Intrinsics.checkNotNullExpressionValue((Object)segments, (String)"segments");
                    String lastSegment = (String)CollectionsKt.last((List)segments);
                    if (TextUtils.isDigitsOnly((CharSequence)lastSegment)) {
                        Resources resources = context.getResources();
                        Intrinsics.checkNotNullExpressionValue((Object)lastSegment, (String)"lastSegment");
                        resources.getResourceEntryName(Integer.parseInt(lastSegment));
                        return true;
                    }
                    if (segments.size() < 2) return exists;
                    String resourceType = (String)segments.get(0);
                    String packageName = $this$exists.getAuthority();
                    int resourceId = context.getResources().getIdentifier(lastSegment, resourceType, packageName);
                    if (resourceId == 0) return exists;
                    return true;
                }
                case 2: {
                    DocumentFile segments = DocumentFile.fromTreeUri((Context)context, (Uri)$this$exists);
                    if (segments == null) return false;
                    boolean bl = segments.exists();
                    return bl;
                }
                case 4: {
                    URL url = new URL($this$exists.toString());
                    URLConnection uRLConnection = url.openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                    HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                    connection.connect();
                    exists = connection.getResponseCode() == 200;
                    connection.disconnect();
                    return exists;
                }
                default: {
                    throw new Exception("Unknown Uri scheme");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static final boolean delete(@NotNull Uri $this$delete, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean deleted = false;
        try {
            if (Intrinsics.areEqual((Object)"file", (Object)$this$delete.getScheme())) {
                boolean bl;
                String string = $this$delete.getPath();
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    bl = FilesKt.deleteRecursively((File)new File(it));
                } else {
                    bl = false;
                }
                deleted = bl;
            } else if (Intrinsics.areEqual((Object)"content", (Object)$this$delete.getScheme())) {
                DocumentFile documentFile = DocumentFile.fromSingleUri((Context)context, (Uri)$this$delete);
                deleted = documentFile != null ? documentFile.delete() : false;
            } else if (UriExtensionsKt.isTreeUri($this$delete)) {
                DocumentFile documentFile = DocumentFile.fromTreeUri((Context)context, (Uri)$this$delete);
                deleted = documentFile != null ? documentFile.delete() : false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Uri findFile(@NotNull Uri $this$findFile, @NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$findFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Uri uri = null;
        try {
            if (UriExtensionsKt.isFileUri($this$findFile)) {
                void $this$toUri$iv;
                void element$iv;
                Object $this$firstOrNull$iv;
                block7: {
                    String string = $this$findFile.getPath();
                    if (string == null) return null;
                    String it = string;
                    boolean $i$a$-let-UriExtensionsKt$findFile$22 = false;
                    File[] fileArray = new File(it).listFiles();
                    if (fileArray == null) return null;
                    File[] $i$a$-let-UriExtensionsKt$findFile$22 = fileArray;
                    boolean $i$f$firstOrNull = false;
                    int n = 0;
                    int n2 = ((void)$this$firstOrNull$iv).length;
                    while (n < n2) {
                        void it2 = element$iv = $this$firstOrNull$iv[n];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)fileName)) {
                            ++n;
                            continue;
                        }
                        break block7;
                    }
                    return null;
                }
                Object v0 = element$iv;
                Object var7_8 = v0;
                if (var7_8 == null) return null;
                $this$firstOrNull$iv = var7_8;
                boolean $i$f$toUri = false;
                Uri uri2 = Uri.fromFile((File)$this$toUri$iv);
                Uri uri3 = uri2;
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"fromFile(this)");
                return uri3;
            }
            if (!UriExtensionsKt.isTreeUri($this$findFile)) return uri;
            DocumentFile documentFile = DocumentFile.fromTreeUri((Context)context, (Uri)$this$findFile);
            if (documentFile == null) return null;
            DocumentFile documentFile2 = documentFile.findFile(fileName);
            if (documentFile2 == null) return null;
            Uri uri4 = documentFile2.getUri();
            return uri4;
        }
        catch (Exception exception) {}
        return uri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean fileExists(@NotNull Uri $this$fileExists, @NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$fileExists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean exists = false;
        try {
            if (UriExtensionsKt.isFileUri($this$fileExists)) {
                File file;
                String string = $this$fileExists.getPath();
                if (string == null) return false;
                String it = string;
                boolean bl = false;
                File it2 = file = new File(it);
                boolean bl2 = false;
                if (!it2.isDirectory()) return false;
                File file2 = file;
                File file3 = file2;
                if (file3 == null) return false;
                File it3 = file3;
                boolean bl3 = false;
                boolean bl4 = new File(it3, fileName).exists();
                return bl4;
            }
            if (!UriExtensionsKt.isTreeUri($this$fileExists)) return exists;
            DocumentFile documentFile = DocumentFile.fromTreeUri((Context)context, (Uri)$this$fileExists);
            if (documentFile == null) return false;
            DocumentFile documentFile2 = documentFile.findFile(fileName);
            if (documentFile2 == null) return false;
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"Recycle"})
    @Nullable
    public static final InputStream openInputStream(@NotNull Uri $this$openInputStream, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$openInputStream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = null;
        try {
            String string = $this$openInputStream.getScheme();
            if (string == null) return inputStream;
            switch (string.hashCode()) {
                case 3143036: {
                    if (string.equals("file")) return context.getContentResolver().openInputStream($this$openInputStream);
                    return inputStream;
                }
                case -368816979: {
                    if (string.equals("android.resource")) return context.getContentResolver().openInputStream($this$openInputStream);
                    return inputStream;
                }
                case 3213448: {
                    if (string.equals("http")) break;
                    return inputStream;
                }
                case 99617003: {
                    if (string.equals("https")) break;
                    return inputStream;
                }
                case 951530617: {
                    if (!string.equals("content")) return inputStream;
                    return context.getContentResolver().openInputStream($this$openInputStream);
                }
            }
            Request.Builder builder = new Request.Builder();
            String string2 = $this$openInputStream.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
            Request request = builder.url(string2).build();
            OkHttpClient client = new OkHttpClient.Builder().build();
            Response response = client.newCall(request).execute();
            ResponseBody body = response.body();
            if (body == null) return inputStream;
            if (response.code() == 200) {
                return body.byteStream();
            }
            Util.closeQuietly((Closeable)((Closeable)response));
            return inputStream;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Recycle"})
    public static final int copyTo(@NotNull Uri $this$copyTo, @NotNull Context context, @NotNull Uri dstUri) {
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dstUri, (String)"dstUri");
        InputStream inputStream = null;
        Ref.ObjectRef outputStream = new Ref.ObjectRef();
        int bytesWritten = -1;
        try {
            outputStream.element = context.getContentResolver().openOutputStream(dstUri);
            inputStream = UriExtensionsKt.openInputStream($this$copyTo, context);
            if (inputStream != null && outputStream.element != null) {
                bytesWritten = InputStreamExtensionsKt.readBytes$default(inputStream, 0, (Function2)new Function2<byte[], Integer, Boolean>((Ref.ObjectRef<OutputStream>)outputStream){
                    final /* synthetic */ Ref.ObjectRef<OutputStream> $outputStream;
                    {
                        this.$outputStream = $outputStream;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull byte[] buffer, int bytesRead) {
                        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                        ((OutputStream)this.$outputStream.element).write(buffer, 0, bytesRead);
                        return true;
                    }
                }, 1, null);
                ((OutputStream)outputStream.element).flush();
            }
        }
        catch (Exception exception) {
        }
        finally {
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                Util.closeQuietly((Closeable)inputStream2);
            }
            OutputStream outputStream2 = (OutputStream)outputStream.element;
            if (outputStream2 != null) {
                Util.closeQuietly((Closeable)outputStream2);
            }
        }
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] readBytes(@NotNull Uri $this$readBytes, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = null;
        byte[] bytes = null;
        try {
            InputStream inputStream2 = inputStream = UriExtensionsKt.openInputStream($this$readBytes, context);
            bytes = (byte[])(inputStream2 != null ? ByteStreamsKt.readBytes((InputStream)inputStream2) : null);
        }
        catch (Exception exception) {
        }
        finally {
            InputStream inputStream3 = inputStream;
            if (inputStream3 != null) {
                Util.closeQuietly((Closeable)inputStream3);
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SuppressLint(value={"Recycle"})
    public static final boolean writeBytes(@NotNull Uri $this$writeBytes, @NotNull Context context, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean result = false;
        OutputStream outputStream = null;
        try {
            OutputStream outputStream2 = context.getContentResolver().openOutputStream($this$writeBytes);
            if (outputStream2 == null) {
                throw new NullPointerException("Could not open the output stream");
            }
            outputStream = outputStream2;
            outputStream.write(bytes);
            outputStream.flush();
            result = true;
        }
        catch (Exception exception) {
            OutputStream outputStream3 = outputStream;
            if (outputStream3 != null) {
                Util.closeQuietly((Closeable)outputStream3);
            }
            catch (Throwable throwable) {
                OutputStream outputStream4 = outputStream;
                if (outputStream4 != null) {
                    Util.closeQuietly((Closeable)outputStream4);
                }
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)outputStream);
        return result;
    }

    @Nullable
    public static final ByteBuffer readToBuffer(@NotNull Uri $this$readToBuffer, @NotNull Context context) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$readToBuffer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        byte[] byArray = UriExtensionsKt.readBytes($this$readToBuffer, context);
        if (byArray != null) {
            byte[] bytes = byArray;
            boolean bl = false;
            Buffer buffer = ByteBuffer.allocateDirect(bytes.length).order(ByteOrder.nativeOrder()).put(bytes).position(0);
            Intrinsics.checkNotNull((Object)buffer, (String)"null cannot be cast to non-null type java.nio.ByteBuffer");
            byteBuffer = (ByteBuffer)buffer;
        } else {
            byteBuffer = null;
        }
        return byteBuffer;
    }
}

