/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.webpandroid.decoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.aureusapps.android.webpandroid.decoder.DecoderConfig;
import com.aureusapps.android.webpandroid.decoder.WebPDecodeListener;
import com.aureusapps.android.webpandroid.decoder.WebPInfo;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0018\u001a\u00020\fH\u0082 J\u0011\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082 J\t\u0010\u001a\u001a\u00020\u0007H\u0082 J#\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0082 J\u0019\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0082 J\t\u0010\u001d\u001a\u00020\fH\u0082 J*\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0006\u0010'\u001a\u00020\fJ\u000e\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/aureusapps/android/webpandroid/decoder/WebPDecoder;", "", "()V", "decodeListeners", "", "Lcom/aureusapps/android/webpandroid/decoder/WebPDecodeListener;", "nativePointer", "", "addDecodeListener", "", "listener", "cancel", "", "configure", "config", "Lcom/aureusapps/android/webpandroid/decoder/DecoderConfig;", "decodeFrames", "context", "Landroid/content/Context;", "srcUri", "Landroid/net/Uri;", "dstUri", "decodeInfo", "Lcom/aureusapps/android/webpandroid/decoder/WebPInfo;", "nativeCancel", "nativeConfigure", "nativeCreate", "nativeDecodeFrames", "nativeDecodeInfo", "nativeRelease", "notifyFrameDecoded", "index", "", "timestamp", "frame", "Landroid/graphics/Bitmap;", "uri", "notifyInfoDecoded", "info", "release", "removeDecodeListener", "webp-android_release"})
@SourceDebugExtension(value={"SMAP\nWebPDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPDecoder.kt\ncom/aureusapps/android/webpandroid/decoder/WebPDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1855#2,2:131\n1855#2,2:133\n*S KotlinDebug\n*F\n+ 1 WebPDecoder.kt\ncom/aureusapps/android/webpandroid/decoder/WebPDecoder\n*L\n45#1:131,2\n51#1:133,2\n*E\n"})
public final class WebPDecoder {
    private final long nativePointer;
    @NotNull
    private final Set<WebPDecodeListener> decodeListeners;

    public WebPDecoder() {
        System.loadLibrary("webpcodec_jni");
        this.decodeListeners = new LinkedHashSet();
        this.nativePointer = this.nativeCreate();
    }

    private final native long nativeCreate();

    private final native void nativeConfigure(DecoderConfig var1);

    private final native void nativeDecodeFrames(Context var1, Uri var2, Uri var3);

    private final native WebPInfo nativeDecodeInfo(Context var1, Uri var2);

    private final native void nativeCancel();

    private final native void nativeRelease();

    private final void notifyInfoDecoded(WebPInfo info) {
        Iterable $this$forEach$iv = this.decodeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPDecodeListener it = (WebPDecodeListener)element$iv;
            boolean bl = false;
            it.onInfoDecoded(info);
        }
    }

    private final void notifyFrameDecoded(int index, long timestamp, Bitmap frame, Uri uri) {
        Iterable $this$forEach$iv = this.decodeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPDecodeListener it = (WebPDecodeListener)element$iv;
            boolean bl = false;
            it.onFrameDecoded(index, timestamp, frame, uri);
        }
    }

    public final boolean addDecodeListener(@NotNull WebPDecodeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.decodeListeners.add(listener);
    }

    public final boolean removeDecodeListener(@NotNull WebPDecodeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.decodeListeners.remove(listener);
    }

    @NotNull
    public final WebPDecoder configure(@NotNull DecoderConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.nativeConfigure(config);
        return this;
    }

    public final void decodeFrames(@NotNull Context context, @NotNull Uri srcUri, @Nullable Uri dstUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)srcUri, (String)"srcUri");
        this.nativeDecodeFrames(context, srcUri, dstUri);
    }

    public static /* synthetic */ void decodeFrames$default(WebPDecoder webPDecoder, Context context, Uri uri, Uri uri2, int n, Object object) {
        if ((n & 4) != 0) {
            uri2 = null;
        }
        webPDecoder.decodeFrames(context, uri, uri2);
    }

    @NotNull
    public final WebPInfo decodeInfo(@NotNull Context context, @NotNull Uri srcUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)srcUri, (String)"srcUri");
        return this.nativeDecodeInfo(context, srcUri);
    }

    public final void cancel() {
        this.nativeCancel();
    }

    public final void release() {
        this.nativeRelease();
    }
}

