/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.webpandroid.encoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.aureusapps.android.webpandroid.encoder.WebPConfig;
import com.aureusapps.android.webpandroid.encoder.WebPEncoderProgressListener;
import com.aureusapps.android.webpandroid.encoder.WebPPreset;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 '2\u00020\u0001:\u0001'B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001d\u001a\u00020\u000fH\u0082 J\u001d\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082 J\u0019\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0082 J!\u0010 \u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0082 J!\u0010!\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0082 J\t\u0010\"\u001a\u00020\u000fH\u0082 J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0006\u0010%\u001a\u00020\u000fJ\u000e\u0010&\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/aureusapps/android/webpandroid/encoder/WebPEncoder;", "", "width", "", "height", "(II)V", "nativePointer", "", "progressListeners", "", "Lcom/aureusapps/android/webpandroid/encoder/WebPEncoderProgressListener;", "addProgressListener", "", "listener", "cancel", "", "configure", "config", "Lcom/aureusapps/android/webpandroid/encoder/WebPConfig;", "preset", "Lcom/aureusapps/android/webpandroid/encoder/WebPPreset;", "encode", "context", "Landroid/content/Context;", "srcBitmap", "Landroid/graphics/Bitmap;", "dstUri", "Landroid/net/Uri;", "srcUri", "nativeCancel", "nativeConfigure", "nativeCreate", "nativeEncode1", "nativeEncode2", "nativeRelease", "notifyProgressChanged", "progress", "release", "removeProgressListener", "Companion", "webp-android_release"})
@SourceDebugExtension(value={"SMAP\nWebPEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPEncoder.kt\ncom/aureusapps/android/webpandroid/encoder/WebPEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1855#2,2:157\n*S KotlinDebug\n*F\n+ 1 WebPEncoder.kt\ncom/aureusapps/android/webpandroid/encoder/WebPEncoder\n*L\n61#1:157,2\n*E\n"})
public final class WebPEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<WebPEncoderProgressListener> progressListeners;
    private final long nativePointer;

    public WebPEncoder(int width, int height) {
        this.progressListeners = new LinkedHashSet();
        this.nativePointer = this.nativeCreate(width, height);
        if (this.nativePointer == 0L) {
            throw new RuntimeException("Failed to create native encoder");
        }
    }

    public /* synthetic */ WebPEncoder(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        this(n, n2);
    }

    private final native long nativeCreate(int var1, int var2);

    private final native void nativeConfigure(WebPConfig var1, WebPPreset var2);

    private final native void nativeEncode1(Context var1, Uri var2, Uri var3);

    private final native void nativeEncode2(Context var1, Bitmap var2, Uri var3);

    private final native void nativeCancel();

    private final native void nativeRelease();

    private final boolean notifyProgressChanged(int progress) {
        boolean encode = false;
        encode = true;
        Iterable $this$forEach$iv = this.progressListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPEncoderProgressListener it = (WebPEncoderProgressListener)element$iv;
            boolean bl = false;
            if (it.onProgressChanged(progress)) continue;
            encode = false;
        }
        return encode;
    }

    public final boolean addProgressListener(@NotNull WebPEncoderProgressListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.progressListeners.add(listener);
    }

    public final boolean removeProgressListener(@NotNull WebPEncoderProgressListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.progressListeners.remove(listener);
    }

    @NotNull
    public final WebPEncoder configure(@Nullable WebPConfig config, @Nullable WebPPreset preset) {
        if (config == null && preset == null) {
            throw new IllegalStateException("Both config and preset cannot be null at the same time");
        }
        this.nativeConfigure(config, preset);
        return this;
    }

    public static /* synthetic */ WebPEncoder configure$default(WebPEncoder webPEncoder, WebPConfig webPConfig, WebPPreset webPPreset, int n, Object object) {
        if ((n & 1) != 0) {
            webPConfig = null;
        }
        if ((n & 2) != 0) {
            webPPreset = null;
        }
        return webPEncoder.configure(webPConfig, webPPreset);
    }

    @NotNull
    public final WebPEncoder encode(@NotNull Context context, @NotNull Uri srcUri, @NotNull Uri dstUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)srcUri, (String)"srcUri");
        Intrinsics.checkNotNullParameter((Object)dstUri, (String)"dstUri");
        this.nativeEncode1(context, srcUri, dstUri);
        return this;
    }

    @NotNull
    public final WebPEncoder encode(@NotNull Context context, @NotNull Bitmap srcBitmap, @NotNull Uri dstUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)srcBitmap, (String)"srcBitmap");
        Intrinsics.checkNotNullParameter((Object)dstUri, (String)"dstUri");
        this.nativeEncode2(context, srcBitmap, dstUri);
        return this;
    }

    public final void cancel() {
        this.nativeCancel();
    }

    public final void release() {
        this.nativeRelease();
    }

    public WebPEncoder() {
        this(0, 0, 3, null);
    }

    static {
        System.loadLibrary("webpcodec_jni");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/aureusapps/android/webpandroid/encoder/WebPEncoder$Companion;", "", "()V", "webp-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

