package com.aureusapps.android.webpandroid

enum class CodecResult(val message: String) {
    SUCCESS("Success"),
    RESULT_FILE_EXISTS("File already exists"),
    RESULT_FILE_NOT_FOUND("File not found"),
    ERROR_NULL_ENCODER("Encoder is missing"),
    ERROR_VERSION_MISMATCH("Version mismatch"),
    ERROR_BITMAP_INFO_EXTRACT_FAILED("Failed to extract bitmap info"),
    ERROR_INVALID_BITMAP_FORMAT("Invalid bitmap format"),
    ERROR_BITMAP_RESIZE_FAILED("Failed to resize bitmap"),
    ERROR_LOCK_BITMAP_PIXELS_FAILED("Failed to lock bitmap pixels"),
    ERROR_UNLOCK_BITMAP_PIXELS_FAILED("Failed to unlock bitmap pixels"),
    ERROR_MEMORY_ERROR("Memory error"),
    ERROR_MARK_ANIMATION_END_FAILED("Failed to mark animation end"),
    ERROR_ANIMATION_ASSEMBLE_FAILED("Failed to assemble animation"),
    ERROR_INVALID_WEBP_CONFIG("Invalid WebP configuration"),
    ERROR_WRITE_TO_URI_FAILED("Failed to write to URI"),
    ERROR_READ_URI_FAILED("Failed to read from URI"),
    ERROR_WEBP_INFO_EXTRACT_FAILED("Failed to extract WebP info"),
    ERROR_WEBP_DECODE_FAILED("Failed to decode WebP data"),
    ERROR_BITMAP_WRITE_TO_URI_FAILED("Failed to write bitmap to URI"),
    ERROR_NULL_DECODER("Decoder is missing"),
    ERROR_FILE_NAME_GENERATION_FAILED("File name generation failed"),
    ERROR_OUT_OF_MEMORY("Memory error allocating objects"),
    ERROR_BITSTREAM_OUT_OF_MEMORY("Memory error while flushing bits"),
    ERROR_NULL_PARAMETER("A pointer parameter is NULL"),
    ERROR_INVALID_CONFIGURATION("Configuration is invalid"),
    ERROR_BAD_DIMENSION("Picture has invalid width/height"),
    ERROR_PARTITION0_OVERFLOW("Partition is bigger than 512k"),
    ERROR_PARTITION_OVERFLOW("Partition is bigger than 16M"),
    ERROR_BAD_WRITE("Error while flushing bytes"),
    ERROR_FILE_TOO_BIG("File is bigger than 4G"),
    ERROR_USER_ABORT("Abort request by user"),
    ERROR_LAST("List terminator. always last."),
    ERROR_INVALID_PARAM("Invalid param"),
    ERROR_BITSTREAM_ERROR("Bitstream error"),
    ERROR_UNSUPPORTED_FEATURE("Unsupported feature"),
    ERROR_SUSPENDED("Suspended"),
    ERROR_NOT_ENOUGH_DATA("Not enough data"),
    ERROR_ANIM_DECODER_CREATE_FAILED("Failed to create animation decoder"),
    ERROR_ANIM_INFO_GET_FAILED("Failed to animation info"),
    ERROR_SET_DATA_SOURCE_FAILED("Failed to set decoder data"),
    ERROR_DATA_SOURCE_NOT_SET("Decoder data source not set"),
    ERROR_NO_MORE_FRAMES("No more frames to decode")
}