/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.webpandroid.decoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.aureusapps.android.webpandroid.CodecException;
import com.aureusapps.android.webpandroid.CodecResult;
import com.aureusapps.android.webpandroid.decoder.DecoderConfig;
import com.aureusapps.android.webpandroid.decoder.FrameDecodeResult;
import com.aureusapps.android.webpandroid.decoder.InfoDecodeResult;
import com.aureusapps.android.webpandroid.decoder.InternalFrameDecodeResult;
import com.aureusapps.android.webpandroid.decoder.WebPDecodeListener;
import com.aureusapps.android.webpandroid.decoder.WebPDecoder;
import com.aureusapps.android.webpandroid.decoder.WebPInfo;
import com.aureusapps.android.webpandroid.utils.CodecHelper;
import com.getkeepsafe.relinker.ReLinker;
import java.nio.Buffer;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 @2\u00020\u0001:\u0001@B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u00020\u000e2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J.\u0010\u0019\u001a\u0002H\u001a\"\u0006\b\u0000\u0010\u001a\u0018\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001eH\u0082\b\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020\u000bJ\t\u0010!\u001a\u00020\u000eH\u0082 J\u0011\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0082 J\t\u0010#\u001a\u00020\tH\u0082 J\u001b\u0010$\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082 J\t\u0010%\u001a\u00020&H\u0082 J\t\u0010'\u001a\u00020(H\u0082 J\t\u0010)\u001a\u00020\u000bH\u0082 J\t\u0010*\u001a\u00020\u001cH\u0082 J\t\u0010+\u001a\u00020\u000eH\u0082 J\t\u0010,\u001a\u00020\u000eH\u0082 J\u0011\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0082 J\u0019\u00100\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0014H\u0082 J\u0006\u00102\u001a\u00020\u001cJ(\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0014H\u0002J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u0016H\u0002J\u0006\u0010;\u001a\u00020\u000eJ\u000e\u0010<\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010=\u001a\u00020\u000eJ\u000e\u0010>\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/J\u000e\u0010?\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/aureusapps/android/webpandroid/decoder/WebPDecoder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "decodeListeners", "", "Lcom/aureusapps/android/webpandroid/decoder/WebPDecodeListener;", "nativePointer", "", "addDecodeListener", "", "listener", "cancel", "", "configure", "config", "Lcom/aureusapps/android/webpandroid/decoder/DecoderConfig;", "decodeFrames", "dstUri", "Landroid/net/Uri;", "decodeInfo", "Lcom/aureusapps/android/webpandroid/decoder/WebPInfo;", "decodeNextFrame", "Lcom/aureusapps/android/webpandroid/decoder/FrameDecodeResult;", "handleResultCode", "T", "resultCode", "", "onSuccess", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "hasNextFrame", "nativeCancel", "nativeConfigure", "nativeCreate", "nativeDecodeFrames", "nativeDecodeInfo", "Lcom/aureusapps/android/webpandroid/decoder/InfoDecodeResult;", "nativeDecodeNextFrame", "Lcom/aureusapps/android/webpandroid/decoder/InternalFrameDecodeResult;", "nativeHasNextFrame", "nativeNextFrameIndex", "nativeRelease", "nativeReset", "nativeSetDataBuffer", "buffer", "Ljava/nio/Buffer;", "nativeSetDataSource", "srcUri", "nextFrameIndex", "notifyFrameDecoded", "index", "timestamp", "frame", "Landroid/graphics/Bitmap;", "uri", "notifyInfoDecoded", "info", "release", "removeDecodeListener", "reset", "setDataBuffer", "setDataSource", "Companion", "webp-android_release"})
@SourceDebugExtension(value={"SMAP\nWebPDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPDecoder.kt\ncom/aureusapps/android/webpandroid/decoder/WebPDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 WebPDecoder.kt\ncom/aureusapps/android/webpandroid/decoder/WebPDecoder$handleResultCode$1\n*L\n1#1,221:1\n74#1,7:226\n82#1:234\n74#1,7:235\n82#1:243\n78#1,5:244\n74#1,7:249\n82#1:257\n1855#2,2:222\n1855#2,2:224\n76#3:233\n76#3:242\n76#3:256\n*S KotlinDebug\n*F\n+ 1 WebPDecoder.kt\ncom/aureusapps/android/webpandroid/decoder/WebPDecoder\n*L\n125#1:226,7\n125#1:234\n136#1:235,7\n136#1:243\n147#1:244,5\n197#1:249,7\n197#1:257\n58#1:222,2\n69#1:224,2\n125#1:233\n136#1:242\n197#1:256\n*E\n"})
public final class WebPDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final long nativePointer;
    @NotNull
    private final Set<WebPDecodeListener> decodeListeners;
    @NotNull
    private static final String TAG = "WebPDecoder";

    public WebPDecoder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        ReLinker.loadLibrary((Context)this.context, (String)"webpcodec_jni");
        this.decodeListeners = new LinkedHashSet();
        this.nativePointer = this.nativeCreate();
    }

    private final native long nativeCreate();

    private final native void nativeConfigure(DecoderConfig var1);

    private final native int nativeSetDataBuffer(Buffer var1);

    private final native int nativeSetDataSource(Context var1, Uri var2);

    private final native InfoDecodeResult nativeDecodeInfo();

    private final native boolean nativeHasNextFrame();

    private final native int nativeNextFrameIndex();

    private final native InternalFrameDecodeResult nativeDecodeNextFrame();

    private final native int nativeDecodeFrames(Context var1, Uri var2);

    private final native void nativeReset();

    private final native void nativeCancel();

    private final native void nativeRelease();

    private final void notifyInfoDecoded(WebPInfo info) {
        Iterable $this$forEach$iv = this.decodeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPDecodeListener listener2 = (WebPDecodeListener)element$iv;
            boolean bl = false;
            listener2.onInfoDecoded(info);
        }
    }

    private final void notifyFrameDecoded(int index, long timestamp, Bitmap frame, Uri uri) {
        Iterable $this$forEach$iv = this.decodeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPDecodeListener listener2 = (WebPDecodeListener)element$iv;
            boolean bl = false;
            listener2.onFrameDecoded(index, timestamp, frame, uri);
        }
    }

    private final /* synthetic */ <T> T handleResultCode(int resultCode, Function0<? extends T> onSuccess) {
        boolean $i$f$handleResultCode = false;
        CodecResult codecResult = CodecHelper.INSTANCE.resultCodeToCodecResult(resultCode);
        if (codecResult == CodecResult.SUCCESS) {
            return (T)onSuccess.invoke();
        }
        throw new CodecException(codecResult);
    }

    static /* synthetic */ Object handleResultCode$default(WebPDecoder $this, int resultCode, Function0 onSuccess, int n, Object object) {
        if ((n & 2) != 0) {
            Intrinsics.needClassReification();
            onSuccess = handleResultCode.1.INSTANCE;
        }
        boolean $i$f$handleResultCode = false;
        CodecResult codecResult = CodecHelper.INSTANCE.resultCodeToCodecResult(resultCode);
        if (codecResult == CodecResult.SUCCESS) {
            return onSuccess.invoke();
        }
        throw new CodecException(codecResult);
    }

    public final boolean addDecodeListener(@NotNull WebPDecodeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.decodeListeners.add(listener2);
    }

    public final boolean removeDecodeListener(@NotNull WebPDecodeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.decodeListeners.remove(listener2);
    }

    @NotNull
    public final WebPDecoder configure(@NotNull DecoderConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.nativeConfigure(config);
        return this;
    }

    public final void setDataBuffer(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int resultCode = this.nativeSetDataBuffer(buffer);
        boolean $i$f$handleResultCode = false;
        CodecResult codecResult$iv = CodecHelper.INSTANCE.resultCodeToCodecResult(resultCode);
        if (codecResult$iv != CodecResult.SUCCESS) {
            throw new CodecException(codecResult$iv);
        }
        boolean bl = false;
    }

    public final void setDataSource(@NotNull Uri srcUri) {
        Intrinsics.checkNotNullParameter((Object)srcUri, (String)"srcUri");
        int resultCode = this.nativeSetDataSource(this.context, srcUri);
        boolean $i$f$handleResultCode = false;
        CodecResult codecResult$iv = CodecHelper.INSTANCE.resultCodeToCodecResult(resultCode);
        if (codecResult$iv != CodecResult.SUCCESS) {
            throw new CodecException(codecResult$iv);
        }
        boolean bl = false;
    }

    @NotNull
    public final WebPInfo decodeInfo() {
        WebPInfo webPInfo;
        InfoDecodeResult decodeResult = this.nativeDecodeInfo();
        WebPDecoder webPDecoder = this;
        int resultCode$iv = decodeResult.getResultCode();
        boolean $i$f$handleResultCode = false;
        CodecResult codecResult$iv = CodecHelper.INSTANCE.resultCodeToCodecResult(resultCode$iv);
        if (codecResult$iv == CodecResult.SUCCESS) {
            boolean bl = false;
            webPInfo = decodeResult.getWebPInfo();
            if (webPInfo == null) {
                throw new RuntimeException("Unexpected null result: webPInfo is null");
            }
        } else {
            throw new CodecException(codecResult$iv);
        }
        return webPInfo;
    }

    public final boolean hasNextFrame() {
        return this.nativeHasNextFrame();
    }

    public final int nextFrameIndex() {
        return this.nativeNextFrameIndex();
    }

    @NotNull
    public final FrameDecodeResult decodeNextFrame() {
        InternalFrameDecodeResult decodeResult = this.nativeDecodeNextFrame();
        CodecResult codecResult = CodecHelper.INSTANCE.resultCodeToCodecResult(decodeResult.getResultCode());
        if (codecResult != CodecResult.SUCCESS && codecResult != CodecResult.ERROR_NO_MORE_FRAMES) {
            throw new CodecException(codecResult);
        }
        return new FrameDecodeResult(decodeResult.getFrame(), decodeResult.getTimestamp(), codecResult);
    }

    public final void decodeFrames(@Nullable Uri dstUri) {
        int resultCode = this.nativeDecodeFrames(this.context, dstUri);
        boolean $i$f$handleResultCode = false;
        CodecResult codecResult$iv = CodecHelper.INSTANCE.resultCodeToCodecResult(resultCode);
        if (codecResult$iv != CodecResult.SUCCESS) {
            throw new CodecException(codecResult$iv);
        }
        boolean bl = false;
    }

    public static /* synthetic */ void decodeFrames$default(WebPDecoder webPDecoder, Uri uri, int n, Object object) {
        if ((n & 1) != 0) {
            uri = null;
        }
        webPDecoder.decodeFrames(uri);
    }

    public final void reset() {
        this.nativeReset();
    }

    public final void cancel() {
        this.nativeCancel();
    }

    public final void release() {
        this.nativeRelease();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/aureusapps/android/webpandroid/decoder/WebPDecoder$Companion;", "", "()V", "TAG", "", "webp-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

