/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.webpandroid.encoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.aureusapps.android.extensions.BitmapUtils;
import com.aureusapps.android.webpandroid.encoder.WebPAnimEncoderOptions;
import com.aureusapps.android.webpandroid.encoder.WebPAnimEncoderProgressListener;
import com.aureusapps.android.webpandroid.encoder.WebPConfig;
import com.aureusapps.android.webpandroid.encoder.WebPPreset;
import com.getkeepsafe.relinker.ReLinker;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eJ\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00002\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0019\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0082 J!\u0010#\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0015H\u0082 J\t\u0010$\u001a\u00020\u001cH\u0082 J\u001d\u0010%\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0082 J#\u0010&\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0082 J\t\u0010'\u001a\u00020\u001cH\u0082 J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0006\u0010+\u001a\u00020\u001cJ\u000e\u0010,\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/aureusapps/android/webpandroid/encoder/WebPAnimEncoder;", "", "context", "Landroid/content/Context;", "width", "", "height", "options", "Lcom/aureusapps/android/webpandroid/encoder/WebPAnimEncoderOptions;", "(Landroid/content/Context;IILcom/aureusapps/android/webpandroid/encoder/WebPAnimEncoderOptions;)V", "nativePointer", "", "progressListeners", "Ljava/util/ArrayList;", "Lcom/aureusapps/android/webpandroid/encoder/WebPAnimEncoderProgressListener;", "Lkotlin/collections/ArrayList;", "addFrame", "timestamp", "srcBitmap", "Landroid/graphics/Bitmap;", "srcUri", "Landroid/net/Uri;", "addProgressListener", "", "listener", "assemble", "dstUri", "cancel", "", "configure", "config", "Lcom/aureusapps/android/webpandroid/encoder/WebPConfig;", "preset", "Lcom/aureusapps/android/webpandroid/encoder/WebPPreset;", "nativeAddFrame", "nativeAssemble", "nativeCancel", "nativeConfigure", "nativeCreate", "nativeRelease", "notifyProgressChanged", "currentFrame", "frameProgress", "release", "removeProgressListener", "webp-android_release"})
@SourceDebugExtension(value={"SMAP\nWebPAnimEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPAnimEncoder.kt\ncom/aureusapps/android/webpandroid/encoder/WebPAnimEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1855#2,2:167\n*S KotlinDebug\n*F\n+ 1 WebPAnimEncoder.kt\ncom/aureusapps/android/webpandroid/encoder/WebPAnimEncoder\n*L\n68#1:167,2\n*E\n"})
public final class WebPAnimEncoder {
    @NotNull
    private final Context context;
    private final long nativePointer;
    @NotNull
    private final ArrayList<WebPAnimEncoderProgressListener> progressListeners;

    public WebPAnimEncoder(@NotNull Context context, int width, int height, @Nullable WebPAnimEncoderOptions options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        ReLinker.loadLibrary((Context)this.context, (String)"webpcodec_jni");
        this.progressListeners = new ArrayList();
        this.nativePointer = this.nativeCreate(width, height, options);
        if (this.nativePointer == 0L) {
            throw new RuntimeException("Failed to create native encoder");
        }
    }

    public /* synthetic */ WebPAnimEncoder(Context context, int n, int n2, WebPAnimEncoderOptions webPAnimEncoderOptions, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            webPAnimEncoderOptions = null;
        }
        this(context, n, n2, webPAnimEncoderOptions);
    }

    private final native long nativeCreate(int var1, int var2, WebPAnimEncoderOptions var3);

    private final native void nativeConfigure(WebPConfig var1, WebPPreset var2);

    private final native void nativeAddFrame(long var1, Bitmap var3);

    private final native void nativeAssemble(Context var1, long var2, Uri var4);

    private final native void nativeCancel();

    private final native void nativeRelease();

    private final boolean notifyProgressChanged(int currentFrame, int frameProgress) {
        boolean encode = false;
        encode = true;
        Iterable $this$forEach$iv = this.progressListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPAnimEncoderProgressListener it = (WebPAnimEncoderProgressListener)element$iv;
            boolean bl = false;
            if (it.onProgressChanged(currentFrame, frameProgress)) continue;
            encode = false;
        }
        return encode;
    }

    public final boolean addProgressListener(@NotNull WebPAnimEncoderProgressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.progressListeners.add(listener2);
    }

    public final boolean removeProgressListener(@NotNull WebPAnimEncoderProgressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.progressListeners.remove(listener2);
    }

    @NotNull
    public final WebPAnimEncoder configure(@Nullable WebPConfig config, @Nullable WebPPreset preset) {
        if (config == null && preset == null) {
            throw new IllegalStateException("Both config and preset cannot be null at the same time");
        }
        this.nativeConfigure(config, preset);
        return this;
    }

    public static /* synthetic */ WebPAnimEncoder configure$default(WebPAnimEncoder webPAnimEncoder, WebPConfig webPConfig, WebPPreset webPPreset, int n, Object object) {
        if ((n & 1) != 0) {
            webPConfig = null;
        }
        if ((n & 2) != 0) {
            webPPreset = null;
        }
        return webPAnimEncoder.configure(webPConfig, webPPreset);
    }

    @NotNull
    public final WebPAnimEncoder addFrame(long timestamp, @NotNull Uri srcUri) {
        Intrinsics.checkNotNullParameter((Object)srcUri, (String)"srcUri");
        Bitmap bitmap = BitmapUtils.decodeUri$default((Context)this.context, (Uri)srcUri, null, (int)4, null);
        if (bitmap == null) {
            throw new RuntimeException("Failed to decode bitmap uri.");
        }
        Bitmap srcBitmap = bitmap;
        this.nativeAddFrame(timestamp, srcBitmap);
        srcBitmap.recycle();
        return this;
    }

    @NotNull
    public final WebPAnimEncoder addFrame(long timestamp, @NotNull Bitmap srcBitmap) {
        Intrinsics.checkNotNullParameter((Object)srcBitmap, (String)"srcBitmap");
        this.nativeAddFrame(timestamp, srcBitmap);
        return this;
    }

    @NotNull
    public final WebPAnimEncoder assemble(long timestamp, @NotNull Uri dstUri) {
        Intrinsics.checkNotNullParameter((Object)dstUri, (String)"dstUri");
        this.nativeAssemble(this.context, timestamp, dstUri);
        return this;
    }

    public final void cancel() {
        this.nativeCancel();
    }

    public final void release() {
        this.nativeRelease();
    }
}

