/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.webpandroid.encoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.aureusapps.android.extensions.BitmapUtils;
import com.aureusapps.android.webpandroid.encoder.WebPConfig;
import com.aureusapps.android.webpandroid.encoder.WebPEncoderProgressListener;
import com.aureusapps.android.webpandroid.encoder.WebPPreset;
import com.getkeepsafe.relinker.ReLinker;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001d\u001a\u00020\u0011H\u0082 J\u001d\u0010\u001e\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0082 J\u0019\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0082 J!\u0010 \u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0082 J\t\u0010!\u001a\u00020\u0011H\u0082 J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0006\u0010$\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/aureusapps/android/webpandroid/encoder/WebPEncoder;", "", "context", "Landroid/content/Context;", "width", "", "height", "(Landroid/content/Context;II)V", "nativePointer", "", "progressListeners", "", "Lcom/aureusapps/android/webpandroid/encoder/WebPEncoderProgressListener;", "addProgressListener", "", "listener", "cancel", "", "configure", "config", "Lcom/aureusapps/android/webpandroid/encoder/WebPConfig;", "preset", "Lcom/aureusapps/android/webpandroid/encoder/WebPPreset;", "encode", "srcBitmap", "Landroid/graphics/Bitmap;", "dstUri", "Landroid/net/Uri;", "srcUri", "nativeCancel", "nativeConfigure", "nativeCreate", "nativeEncode", "nativeRelease", "notifyProgressChanged", "progress", "release", "removeProgressListener", "webp-android_release"})
@SourceDebugExtension(value={"SMAP\nWebPEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPEncoder.kt\ncom/aureusapps/android/webpandroid/encoder/WebPEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1855#2,2:153\n*S KotlinDebug\n*F\n+ 1 WebPEncoder.kt\ncom/aureusapps/android/webpandroid/encoder/WebPEncoder\n*L\n56#1:153,2\n*E\n"})
public final class WebPEncoder {
    @NotNull
    private final Context context;
    @NotNull
    private final Set<WebPEncoderProgressListener> progressListeners;
    private final long nativePointer;

    public WebPEncoder(@NotNull Context context, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        ReLinker.loadLibrary((Context)this.context, (String)"webpcodec_jni");
        this.progressListeners = new LinkedHashSet();
        this.nativePointer = this.nativeCreate(width, height);
        if (this.nativePointer == 0L) {
            throw new RuntimeException("Failed to create native encoder.");
        }
    }

    public /* synthetic */ WebPEncoder(Context context, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        this(context, n, n2);
    }

    private final native long nativeCreate(int var1, int var2);

    private final native void nativeConfigure(WebPConfig var1, WebPPreset var2);

    private final native void nativeEncode(Context var1, Bitmap var2, Uri var3);

    private final native void nativeCancel();

    private final native void nativeRelease();

    private final boolean notifyProgressChanged(int progress) {
        boolean encode = false;
        encode = true;
        Iterable $this$forEach$iv = this.progressListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebPEncoderProgressListener it = (WebPEncoderProgressListener)element$iv;
            boolean bl = false;
            if (it.onProgressChanged(progress)) continue;
            encode = false;
        }
        return encode;
    }

    public final boolean addProgressListener(@NotNull WebPEncoderProgressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.progressListeners.add(listener2);
    }

    public final boolean removeProgressListener(@NotNull WebPEncoderProgressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.progressListeners.remove(listener2);
    }

    @NotNull
    public final WebPEncoder configure(@Nullable WebPConfig config, @Nullable WebPPreset preset) {
        if (config == null && preset == null) {
            throw new IllegalStateException("Both config and preset cannot be null at the same time");
        }
        this.nativeConfigure(config, preset);
        return this;
    }

    public static /* synthetic */ WebPEncoder configure$default(WebPEncoder webPEncoder, WebPConfig webPConfig, WebPPreset webPPreset, int n, Object object) {
        if ((n & 1) != 0) {
            webPConfig = null;
        }
        if ((n & 2) != 0) {
            webPPreset = null;
        }
        return webPEncoder.configure(webPConfig, webPPreset);
    }

    @NotNull
    public final WebPEncoder encode(@NotNull Uri srcUri, @NotNull Uri dstUri) {
        Intrinsics.checkNotNullParameter((Object)srcUri, (String)"srcUri");
        Intrinsics.checkNotNullParameter((Object)dstUri, (String)"dstUri");
        Bitmap bitmap = BitmapUtils.decodeUri$default((Context)this.context, (Uri)srcUri, null, (int)4, null);
        if (bitmap == null) {
            throw new RuntimeException("Failed to decode bitmap from uri.");
        }
        Bitmap srcBitmap = bitmap;
        this.nativeEncode(this.context, srcBitmap, dstUri);
        srcBitmap.recycle();
        return this;
    }

    @NotNull
    public final WebPEncoder encode(@NotNull Bitmap srcBitmap, @NotNull Uri dstUri) {
        Intrinsics.checkNotNullParameter((Object)srcBitmap, (String)"srcBitmap");
        Intrinsics.checkNotNullParameter((Object)dstUri, (String)"dstUri");
        this.nativeEncode(this.context, srcBitmap, dstUri);
        return this;
    }

    public final void cancel() {
        this.nativeCancel();
    }

    public final void release() {
        this.nativeRelease();
    }
}

