/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.servicer;

import com.austinv11.servicer.WireService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"com.austinv11.servicer.WireService"})
public class ServicerProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, Set> services = new HashMap<String, Set>();
        for (Element element : roundEnv.getElementsAnnotatedWith(WireService.class)) {
            WireService[] serviceAnnotations;
            if (element.getKind() != ElementKind.CLASS) continue;
            for (WireService service : serviceAnnotations = (WireService[])element.getAnnotationsByType(WireService.class)) {
                String serviceName;
                try {
                    serviceName = service.value().getCanonicalName();
                }
                catch (MirroredTypeException e) {
                    serviceName = e.getTypeMirror().toString();
                }
                if (!services.containsKey(serviceName)) {
                    services.put(serviceName, new HashSet());
                }
                ((Set)services.get(serviceName)).add(element.asType().toString());
            }
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Found " + services.size() + " services!");
        services.forEach((k, v) -> {
            try {
                FileObject fo = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + k, new Element[0]);
                try (Writer w = fo.openWriter();){
                    for (String impl : v) {
                        this.messager.printMessage(Diagnostic.Kind.NOTE, "Setting up " + impl + " for use as a " + k + " implementation!");
                        w.append(impl).append("\n");
                    }
                }
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        });
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return super.getSupportedSourceVersion();
    }
}

