/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api;

import com.auth0.spring.security.api.Auth0AuthorityStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class Auth0UserDetails
implements UserDetails {
    private static final long serialVersionUID = 2058797193125711681L;
    private static final Logger logger = LoggerFactory.getLogger(Auth0UserDetails.class);
    private Map<String, Object> details;
    private String username;
    private boolean emailVerified;
    private Collection<GrantedAuthority> authorities = null;

    public Auth0UserDetails(Map<String, Object> map, Auth0AuthorityStrategy authorityStrategy) {
        this.details = map;
        this.username = map.containsKey("email") ? map.get("email").toString() : (map.containsKey("username") ? map.get("username").toString() : (map.containsKey("user_id") ? map.get("user_id").toString() : "UNKNOWN_USER"));
        if (map.containsKey("email")) {
            this.emailVerified = Boolean.valueOf(map.get("email_verified").toString());
        }
        this.setupGrantedAuthorities(map, authorityStrategy);
    }

    private void setupGrantedAuthorities(Map<String, Object> map, Auth0AuthorityStrategy authorityStrategy) {
        this.authorities = new ArrayList<GrantedAuthority>();
        String authorityStrategyName = authorityStrategy.toString();
        if (map.containsKey(authorityStrategyName)) {
            try {
                List<Object> authorities = new ArrayList();
                if (Auth0AuthorityStrategy.SCOPE.equals((Object)authorityStrategy)) {
                    String authoritiesStr = (String)map.get(authorityStrategyName);
                    if (authoritiesStr != null) {
                        authorities = Arrays.asList(authoritiesStr.split("\\s+"));
                    }
                } else {
                    authorities = (ArrayList)map.get(authorityStrategyName);
                }
                for (String authority : authorities) {
                    this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
                }
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                logger.error("Error in casting the roles object");
            }
        }
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        throw new UnsupportedOperationException("Password is protected");
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return false;
    }

    public boolean isAccountNonLocked() {
        return false;
    }

    public boolean isCredentialsNonExpired() {
        return false;
    }

    public boolean isEnabled() {
        return this.emailVerified;
    }

    public Object getAuth0Attribute(String attributeName) {
        return this.details.get(attributeName);
    }
}

