/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api;

import com.auth0.spring.security.api.Auth0TokenException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class Auth0AuthenticationEntryPoint
implements AuthenticationEntryPoint {
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        PrintWriter writer = response.getWriter();
        if (this.isPreflight(request)) {
            response.setStatus(204);
        } else if (authException instanceof Auth0TokenException) {
            response.sendError(401, authException.getMessage());
            writer.println("HTTP Status 401 - " + authException.getMessage());
        } else {
            response.sendError(403, authException.getMessage());
            writer.println("HTTP Status 403 - " + authException.getMessage());
        }
    }

    private boolean isPreflight(HttpServletRequest request) {
        return "OPTIONS".equals(request.getMethod());
    }
}

