/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.JWTVerifyException;
import com.auth0.jwt.internal.org.apache.commons.lang3.Validate;
import com.auth0.jwt.pem.PemReader;
import com.auth0.spring.security.api.Auth0AuthorityStrategy;
import com.auth0.spring.security.api.Auth0JWTToken;
import com.auth0.spring.security.api.Auth0TokenException;
import com.auth0.spring.security.api.Auth0UserDetails;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class Auth0AuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Log logger = LogFactory.getLog(Auth0AuthenticationProvider.class);
    private static final AuthenticationException AUTH_ERROR = new Auth0TokenException("Authentication Error");
    private JWTVerifier jwtVerifier;
    private String domain;
    private String issuer;
    private String clientId;
    private String clientSecret;
    private String securedRoute;
    private boolean base64EncodedSecret;
    private Auth0AuthorityStrategy authorityStrategy;
    private Algorithm signingAlgorithm;
    private String publicKeyPath;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String token = ((Auth0JWTToken)authentication).getJwt();
        logger.info((Object)("Trying to authenticate with token: " + token));
        try {
            Auth0JWTToken tokenAuth = (Auth0JWTToken)authentication;
            Map decoded = this.jwtVerifier.verify(token);
            logger.debug((Object)("Decoded JWT token" + decoded));
            tokenAuth.setAuthenticated(true);
            tokenAuth.setPrincipal(new Auth0UserDetails(decoded, this.authorityStrategy));
            tokenAuth.setDetails(decoded);
            return authentication;
        }
        catch (InvalidKeyException e) {
            logger.debug((Object)("InvalidKeyException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug((Object)("NoSuchAlgorithmException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (IllegalStateException e) {
            logger.debug((Object)("IllegalStateException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (SignatureException e) {
            logger.debug((Object)("SignatureException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (IOException e) {
            logger.debug((Object)("IOException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (JWTVerifyException e) {
            logger.debug((Object)("JWTVerifyException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
    }

    public boolean supports(Class<?> authentication) {
        return Auth0JWTToken.class.isAssignableFrom(authentication);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.clientSecret == null || this.clientId == null) {
            throw new IllegalStateException("client secret and client id are not set for Auth0AuthenticationProvider");
        }
        if (this.securedRoute == null) {
            throw new IllegalStateException("You must set which route pattern is used to check for users so that they must be authenticated");
        }
        switch (this.signingAlgorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                if (this.base64EncodedSecret) {
                    new Base64(true);
                    this.jwtVerifier = new JWTVerifier(Base64.decodeBase64((String)this.clientSecret), this.clientId, this.issuer);
                } else {
                    this.jwtVerifier = new JWTVerifier(this.clientSecret, this.clientId, this.issuer);
                }
                return;
            }
            case RS256: 
            case RS384: 
            case RS512: {
                Validate.notEmpty((CharSequence)this.publicKeyPath);
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    File file = new File(classLoader.getResource(this.publicKeyPath).getFile());
                    String publicKeyRealPath = file.getAbsolutePath();
                    PublicKey publicKey = PemReader.readPublicKey((String)publicKeyRealPath);
                    Validate.notNull((Object)publicKey);
                    this.jwtVerifier = new JWTVerifier(publicKey, this.clientId);
                    return;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e.getCause());
                }
            }
        }
        throw new IllegalStateException("Unsupported signing method: " + this.signingAlgorithm.getValue());
    }

    protected String getDomain() {
        return this.domain;
    }

    protected void setDomain(String domain) {
        this.domain = domain;
    }

    protected String getIssuer() {
        return this.issuer;
    }

    protected void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected void setClientId(String clientId) {
        this.clientId = clientId;
    }

    protected String getClientSecret() {
        return this.clientSecret;
    }

    protected void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    protected String getSecuredRoute() {
        return this.securedRoute;
    }

    protected void setSecuredRoute(String securedRoute) {
        this.securedRoute = securedRoute;
    }

    protected Auth0AuthorityStrategy getAuthorityStrategy() {
        return this.authorityStrategy;
    }

    protected void setAuthorityStrategy(Auth0AuthorityStrategy authorityStrategy) {
        this.authorityStrategy = authorityStrategy;
    }

    protected boolean isBase64EncodedSecret() {
        return this.base64EncodedSecret;
    }

    protected void setBase64EncodedSecret(boolean base64EncodedSecret) {
        this.base64EncodedSecret = base64EncodedSecret;
    }

    protected Algorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    protected void setSigningAlgorithm(Algorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    protected String getPublicKeyPath() {
        return this.publicKeyPath;
    }

    protected void setPublicKeyPath(String publicKeyPath) {
        this.publicKeyPath = publicKeyPath;
    }
}

