/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api;

import com.auth0.jwt.Algorithm;
import com.auth0.spring.security.api.Auth0AuthenticationEntryPoint;
import com.auth0.spring.security.api.Auth0AuthenticationFilter;
import com.auth0.spring.security.api.Auth0AuthenticationProvider;
import com.auth0.spring.security.api.Auth0AuthorityStrategy;
import com.auth0.spring.security.api.Auth0CORSFilter;
import com.auth0.spring.security.api.authority.AuthorityStrategy;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Order(value=0x7FFFFFF8)
@ConditionalOnProperty(prefix="auth0", name={"defaultAuth0ApiSecurityEnabled"})
public class Auth0SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${auth0.domain}")
    protected String domain;
    @Value(value="${auth0.issuer}")
    protected String issuer;
    @Value(value="${auth0.clientId}")
    protected String clientId;
    @Value(value="${auth0.clientSecret}")
    protected String clientSecret;
    @Value(value="${auth0.securedRoute}")
    protected String securedRoute;
    @Value(value="${auth0.authorityStrategy}")
    protected String authorityStrategy;
    @Value(value="${auth0.base64EncodedSecret}")
    protected boolean base64EncodedSecret;
    @Value(value="${auth0.signingAlgorithm:HS256}")
    protected String signingAlgorithm;
    @Value(value="${auth0.publicKeyPath:}")
    protected String publicKeyPath;

    @Autowired
    @Bean(name={"auth0AuthenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public Auth0CORSFilter simpleCORSFilter() {
        return new Auth0CORSFilter();
    }

    @Bean(name={"authorityStrategy"})
    public AuthorityStrategy authorityStrategy() {
        if (!Auth0AuthorityStrategy.contains(this.authorityStrategy)) {
            throw new IllegalStateException("Configuration error, illegal authority strategy");
        }
        return Auth0AuthorityStrategy.valueOf(this.authorityStrategy).getStrategy();
    }

    @Bean(name={"auth0AuthenticationProvider"})
    public Auth0AuthenticationProvider auth0AuthenticationProvider() {
        Auth0AuthenticationProvider authenticationProvider = new Auth0AuthenticationProvider();
        authenticationProvider.setDomain(this.domain);
        authenticationProvider.setIssuer(this.issuer);
        authenticationProvider.setClientId(this.clientId);
        authenticationProvider.setClientSecret(this.clientSecret);
        authenticationProvider.setSecuredRoute(this.securedRoute);
        authenticationProvider.setAuthorityStrategy(this.authorityStrategy());
        authenticationProvider.setBase64EncodedSecret(this.base64EncodedSecret);
        authenticationProvider.setSigningAlgorithm(Algorithm.valueOf((String)this.signingAlgorithm));
        authenticationProvider.setPublicKeyPath(this.publicKeyPath);
        return authenticationProvider;
    }

    @Bean(name={"auth0EntryPoint"})
    public Auth0AuthenticationEntryPoint auth0AuthenticationEntryPoint() {
        return new Auth0AuthenticationEntryPoint();
    }

    @Bean(name={"auth0Filter"})
    public Auth0AuthenticationFilter auth0AuthenticationFilter(Auth0AuthenticationEntryPoint entryPoint) {
        Auth0AuthenticationFilter filter = new Auth0AuthenticationFilter();
        filter.setEntryPoint(entryPoint);
        return filter;
    }

    @Bean(name={"auth0AuthenticationFilterRegistration"})
    public FilterRegistrationBean auth0AuthenticationFilterRegistration(Auth0AuthenticationFilter filter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)filter);
        filterRegistrationBean.setEnabled(false);
        return filterRegistrationBean;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.auth0AuthenticationProvider());
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        http.addFilterAfter((Filter)this.auth0AuthenticationFilter(this.auth0AuthenticationEntryPoint()), SecurityContextPersistenceFilter.class).addFilterBefore((Filter)this.simpleCORSFilter(), Auth0AuthenticationFilter.class);
        this.authorizeRequests(http);
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    protected void authorizeRequests(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{this.securedRoute})).authenticated().antMatchers(new String[]{"/**"})).permitAll();
    }
}

