/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api;

import com.auth0.spring.security.api.authority.AuthorityStrategy;
import com.auth0.spring.security.api.authority.ListAttributeStrategy;
import com.auth0.spring.security.api.authority.StringAttributeStrategy;

public enum Auth0AuthorityStrategy {
    GROUPS("groups", new ListAttributeStrategy("groups")),
    ROLES("roles", new ListAttributeStrategy("roles")),
    SCOPE("scope", new StringAttributeStrategy("scope"));

    private final String name;
    private final AuthorityStrategy strategy;

    private Auth0AuthorityStrategy(String name, AuthorityStrategy strategy) {
        this.name = name;
        this.strategy = strategy;
    }

    public AuthorityStrategy getStrategy() {
        return this.strategy;
    }

    public String toString() {
        return this.name;
    }

    public static boolean contains(String value) {
        for (Auth0AuthorityStrategy authorityStrategy : Auth0AuthorityStrategy.values()) {
            if (!authorityStrategy.name().equals(value)) continue;
            return true;
        }
        return false;
    }
}

