/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api.authentication;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.spring.security.api.JwtAuthenticationProvider;
import com.auth0.spring.security.api.authentication.AuthenticationJsonWebToken;
import com.auth0.spring.security.api.authentication.JwtAuthentication;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class PreAuthenticatedAuthenticationJsonWebToken
implements Authentication,
JwtAuthentication {
    private static Logger logger = LoggerFactory.getLogger(JwtAuthenticationProvider.class);
    private final DecodedJWT token;

    PreAuthenticatedAuthenticationJsonWebToken(DecodedJWT token) {
        this.token = token;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.emptyList();
    }

    public Object getCredentials() {
        return this.token.getToken();
    }

    public Object getDetails() {
        return this.token;
    }

    public Object getPrincipal() {
        return this.token.getSubject();
    }

    public boolean isAuthenticated() {
        return false;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public String getName() {
        return this.token.getSubject();
    }

    public static PreAuthenticatedAuthenticationJsonWebToken usingToken(String token) {
        if (token == null) {
            logger.debug("No token was provided to build {}", (Object)PreAuthenticatedAuthenticationJsonWebToken.class.getName());
            return null;
        }
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return new PreAuthenticatedAuthenticationJsonWebToken(jwt);
        }
        catch (JWTDecodeException e) {
            logger.debug("Failed to decode token as jwt", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getToken() {
        return this.token.getToken();
    }

    @Override
    public String getKeyId() {
        return this.token.getKeyId();
    }

    @Override
    public Authentication verify(JWTVerifier verifier) throws JWTVerificationException {
        return new AuthenticationJsonWebToken(this.token.getToken(), verifier);
    }
}

