/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api;

import com.auth0.jwk.InvalidPublicKeyException;
import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.spring.security.api.authentication.JwtAuthentication;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class JwtAuthenticationProvider
implements AuthenticationProvider {
    private static Logger logger = LoggerFactory.getLogger(JwtAuthenticationProvider.class);
    private final byte[] secret;
    private final String issuer;
    private final String audience;
    private final JwkProvider jwkProvider;
    private long leeway = 0L;

    public JwtAuthenticationProvider(byte[] secret, String issuer, String audience) {
        this.secret = secret;
        this.issuer = issuer;
        this.audience = audience;
        this.jwkProvider = null;
    }

    public JwtAuthenticationProvider(JwkProvider jwkProvider, String issuer, String audience) {
        this.jwkProvider = jwkProvider;
        this.secret = null;
        this.issuer = issuer;
        this.audience = audience;
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthentication.class.isAssignableFrom(authentication);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        JwtAuthentication jwt = (JwtAuthentication)authentication;
        try {
            Authentication jwtAuth = jwt.verify(this.jwtVerifier(jwt));
            logger.info("Authenticated with jwt with scopes {}", (Object)jwtAuth.getAuthorities());
            return jwtAuth;
        }
        catch (JWTVerificationException e) {
            throw new BadCredentialsException("Not a valid token", (Throwable)e);
        }
    }

    public JwtAuthenticationProvider withJwtVerifierLeeway(long leeway) {
        this.leeway = leeway;
        return this;
    }

    private JWTVerifier jwtVerifier(JwtAuthentication authentication) throws AuthenticationException {
        if (this.secret != null) {
            return JwtAuthenticationProvider.providerForHS256(this.secret, this.issuer, this.audience, this.leeway);
        }
        String kid = authentication.getKeyId();
        if (kid == null) {
            throw new BadCredentialsException("No kid found in jwt");
        }
        if (this.jwkProvider == null) {
            throw new AuthenticationServiceException("Missing jwk provider");
        }
        try {
            Jwk jwk = this.jwkProvider.get(kid);
            return JwtAuthenticationProvider.providerForRS256((RSAPublicKey)jwk.getPublicKey(), this.issuer, this.audience, this.leeway);
        }
        catch (SigningKeyNotFoundException e) {
            throw new AuthenticationServiceException("Could not retrieve jwks from issuer", (Throwable)e);
        }
        catch (InvalidPublicKeyException e) {
            throw new AuthenticationServiceException("Could not retrieve public key from issuer", (Throwable)e);
        }
        catch (JwkException e) {
            throw new AuthenticationServiceException("Cannot authenticate with jwt", (Throwable)e);
        }
    }

    private static JWTVerifier providerForRS256(RSAPublicKey publicKey, String issuer, String audience, long leeway) {
        return JWT.require((Algorithm)Algorithm.RSA256((RSAPublicKey)publicKey, null)).withIssuer(new String[]{issuer}).withAudience(new String[]{audience}).acceptLeeway(leeway).build();
    }

    private static JWTVerifier providerForHS256(byte[] secret, String issuer, String audience, long leeway) {
        return JWT.require((Algorithm)Algorithm.HMAC256((byte[])secret)).withIssuer(new String[]{issuer}).withAudience(new String[]{audience}).acceptLeeway(leeway).build();
    }
}

