/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api.authentication;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.spring.security.api.authentication.JwtAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AuthenticationJsonWebToken
implements Authentication,
JwtAuthentication {
    private final DecodedJWT decoded;
    private boolean authenticated;

    AuthenticationJsonWebToken(String token, JWTVerifier verifier) throws JWTVerificationException {
        this.decoded = verifier == null ? JWT.decode((String)token) : verifier.verify(token);
        this.authenticated = verifier != null;
    }

    @Override
    public String getToken() {
        return this.decoded.getToken();
    }

    @Override
    public String getKeyId() {
        return this.decoded.getKeyId();
    }

    @Override
    public Authentication verify(JWTVerifier verifier) throws JWTVerificationException {
        return new AuthenticationJsonWebToken(this.getToken(), verifier);
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        String scope = this.decoded.getClaim("scope").asString();
        if (scope == null || scope.trim().isEmpty()) {
            return new ArrayList();
        }
        String[] scopes = scope.split(" ");
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>(scopes.length);
        for (String value : scopes) {
            authorities.add(new SimpleGrantedAuthority(value));
        }
        return authorities;
    }

    public Object getCredentials() {
        return this.decoded.getToken();
    }

    public Object getDetails() {
        return this.decoded;
    }

    public Object getPrincipal() {
        return this.decoded.getSubject();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (isAuthenticated) {
            throw new IllegalArgumentException("Must create a new instance to specify that the authentication is valid");
        }
        this.authenticated = false;
    }

    public String getName() {
        return this.decoded.getSubject();
    }
}

