/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api;

import com.auth0.spring.security.api.authentication.PreAuthenticatedAuthenticationJsonWebToken;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;

public class BearerSecurityContextRepository
implements SecurityContextRepository {
    private static final Logger logger = LoggerFactory.getLogger(BearerSecurityContextRepository.class);

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        String token = this.tokenFromRequest(requestResponseHolder.getRequest());
        PreAuthenticatedAuthenticationJsonWebToken authentication = PreAuthenticatedAuthenticationJsonWebToken.usingToken(token);
        if (authentication != null) {
            context.setAuthentication((Authentication)authentication);
            logger.debug("Found bearer token in request. Saving it in SecurityContext");
        }
        return context;
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
    }

    public boolean containsContext(HttpServletRequest request) {
        return this.tokenFromRequest(request) != null;
    }

    private String tokenFromRequest(HttpServletRequest request) {
        String value = request.getHeader("Authorization");
        if (value == null || !value.toLowerCase().startsWith("bearer")) {
            return null;
        }
        String[] parts = value.split(" ");
        if (parts.length < 2) {
            return null;
        }
        return parts[1].trim();
    }
}

