/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.api;

import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.spring.security.api.BearerSecurityContextRepository;
import com.auth0.spring.security.api.JwtAccessDeniedHandler;
import com.auth0.spring.security.api.JwtAuthenticationEntryPoint;
import com.auth0.spring.security.api.JwtAuthenticationProvider;
import org.apache.commons.codec.binary.Base64;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.context.SecurityContextRepository;

public class JwtWebSecurityConfigurer {
    final String audience;
    final String[] issuers;
    final AuthenticationProvider provider;

    private JwtWebSecurityConfigurer(String audience, String[] issuers, AuthenticationProvider authenticationProvider) {
        this.audience = audience;
        this.issuers = issuers;
        this.provider = authenticationProvider;
    }

    public static JwtWebSecurityConfigurer forRS256(String audience, String issuer) {
        return JwtWebSecurityConfigurer.forRS256(audience, new String[]{issuer});
    }

    public static JwtWebSecurityConfigurer forRS256(String audience, String issuer, AuthenticationProvider provider) {
        return JwtWebSecurityConfigurer.forRS256(audience, new String[]{issuer}, provider);
    }

    public static JwtWebSecurityConfigurer forRS256(String audience, String[] issuers) {
        JwkProvider jwkProvider = new JwkProviderBuilder(issuers[0]).build();
        return new JwtWebSecurityConfigurer(audience, issuers, new JwtAuthenticationProvider(jwkProvider, issuers, audience));
    }

    public static JwtWebSecurityConfigurer forRS256(String audience, String[] issuers, AuthenticationProvider provider) {
        return new JwtWebSecurityConfigurer(audience, issuers, provider);
    }

    public static JwtWebSecurityConfigurer forHS256WithBase64Secret(String audience, String issuer, String secret) {
        return JwtWebSecurityConfigurer.forHS256WithBase64Secret(audience, new String[]{issuer}, secret);
    }

    public static JwtWebSecurityConfigurer forHS256(String audience, String issuer, byte[] secret) {
        return JwtWebSecurityConfigurer.forHS256(audience, new String[]{issuer}, secret);
    }

    public static JwtWebSecurityConfigurer forHS256(String audience, String issuer, AuthenticationProvider provider) {
        return JwtWebSecurityConfigurer.forHS256(audience, new String[]{issuer}, provider);
    }

    public static JwtWebSecurityConfigurer forHS256WithBase64Secret(String audience, String[] issuers, String secret) {
        byte[] secretBytes = new Base64(true).decode(secret);
        return new JwtWebSecurityConfigurer(audience, issuers, new JwtAuthenticationProvider(secretBytes, issuers, audience));
    }

    public static JwtWebSecurityConfigurer forHS256(String audience, String[] issuers, byte[] secret) {
        return new JwtWebSecurityConfigurer(audience, issuers, new JwtAuthenticationProvider(secret, issuers, audience));
    }

    public static JwtWebSecurityConfigurer forHS256(String audience, String[] issuers, AuthenticationProvider provider) {
        return new JwtWebSecurityConfigurer(audience, issuers, provider);
    }

    public HttpSecurity configure(HttpSecurity http) throws Exception {
        return (HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.authenticationProvider(this.provider).securityContext().securityContextRepository((SecurityContextRepository)new BearerSecurityContextRepository()).and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new JwtAuthenticationEntryPoint()).accessDeniedHandler((AccessDeniedHandler)new JwtAccessDeniedHandler()).and()).httpBasic().disable()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and();
    }
}

