/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.mvc;

import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.JWTVerifyException;
import com.auth0.spring.security.mvc.Auth0JWTToken;
import com.auth0.spring.security.mvc.Auth0TokenException;
import com.auth0.spring.security.mvc.Auth0UserDetails;
import com.auth0.web.Auth0User;
import com.auth0.web.SessionUtils;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class Auth0AuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final AuthenticationException AUTH_ERROR = new Auth0TokenException("Authentication Error");
    private JWTVerifier jwtVerifier = null;
    private String clientSecret = null;
    private String clientId = null;
    private String securedRoute = null;
    private final Log logger = LogFactory.getLog(this.getClass());

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            String token = ((Auth0JWTToken)authentication).getJwt();
            this.logger.info((Object)("Trying to authenticate with token: " + token));
            Auth0JWTToken tokenAuth = (Auth0JWTToken)authentication;
            Map decoded = this.jwtVerifier.verify(token);
            this.logger.debug((Object)("Decoded JWT token" + decoded));
            tokenAuth.setAuthenticated(true);
            ServletRequestAttributes servletReqAttr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest req = servletReqAttr.getRequest();
            Auth0User auth0User = SessionUtils.getAuth0User((HttpServletRequest)req);
            Validate.notNull((Object)auth0User);
            tokenAuth.setPrincipal(new Auth0UserDetails(auth0User));
            tokenAuth.setDetails(decoded);
            return authentication;
        }
        catch (InvalidKeyException e) {
            this.logger.debug((Object)("InvalidKeyException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.debug((Object)("NoSuchAlgorithmException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (IllegalStateException e) {
            this.logger.debug((Object)("IllegalStateException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (SignatureException e) {
            this.logger.debug((Object)("SignatureException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (IOException e) {
            this.logger.debug((Object)("IOException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (JWTVerifyException e) {
            this.logger.debug((Object)("JWTVerifyException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
    }

    public boolean supports(Class<?> authentication) {
        return Auth0JWTToken.class.isAssignableFrom(authentication);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.clientSecret == null || this.clientId == null) {
            throw new RuntimeException("client secret and client id are not set for Auth0AuthenticationProvider");
        }
        if (this.securedRoute == null) {
            throw new RuntimeException("You must set which route pattern is used to check for users so that they must be authenticated");
        }
        new Base64(true);
        this.jwtVerifier = new JWTVerifier(Base64.decodeBase64((String)this.clientSecret), this.clientId);
    }

    public String getSecuredRoute() {
        return this.securedRoute;
    }

    public void setSecuredRoute(String securedRoute) {
        this.securedRoute = securedRoute;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

