/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.mvc;

import com.auth0.spring.security.mvc.Auth0AuthenticationEntryPoint;
import com.auth0.spring.security.mvc.Auth0AuthenticationFilter;
import com.auth0.spring.security.mvc.Auth0AuthenticationProvider;
import com.auth0.spring.security.mvc.Auth0CORSFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;

@Configuration
@EnableWebSecurity(debug=true)
@ConditionalOnProperty(prefix="auth0", name={"defaultAuth0WebSecurityEnabled"})
public class Auth0Configuration
extends WebSecurityConfigurerAdapter {
    @Value(value="${auth0.clientId}")
    private String clientId;
    @Value(value="${auth0.clientSecret}")
    private String clientSecret;
    @Value(value="${auth0.securedRoute}")
    private String securedRoute;

    @Autowired
    @Bean(name={"auth0AuthenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public Auth0CORSFilter simpleCORSFilter() {
        return new Auth0CORSFilter();
    }

    @Bean(name={"auth0AuthenticationProvider"})
    public Auth0AuthenticationProvider auth0AuthenticationProvider() {
        Auth0AuthenticationProvider authenticationProvider = new Auth0AuthenticationProvider();
        authenticationProvider.setClientId(this.getClientId());
        authenticationProvider.setClientSecret(this.getClientSecret());
        authenticationProvider.setSecuredRoute(this.getSecuredRoute());
        return authenticationProvider;
    }

    @Bean(name={"auth0EntryPoint"})
    public Auth0AuthenticationEntryPoint auth0AuthenticationEntryPoint() {
        return new Auth0AuthenticationEntryPoint();
    }

    @Bean(name={"auth0Filter"})
    public Auth0AuthenticationFilter auth0AuthenticationFilter(Auth0AuthenticationEntryPoint entryPoint) {
        Auth0AuthenticationFilter filter = new Auth0AuthenticationFilter();
        filter.setEntryPoint(entryPoint);
        return filter;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.auth0AuthenticationProvider());
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).addFilterAfter((Filter)this.auth0AuthenticationFilter(this.auth0AuthenticationEntryPoint()), SecurityContextPersistenceFilter.class).addFilterBefore((Filter)this.simpleCORSFilter(), Auth0AuthenticationFilter.class).antMatcher("/**").authorizeRequests().antMatchers(new String[]{this.securedRoute})).authenticated();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER);
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected String getClientSecret() {
        return this.clientSecret;
    }

    protected String getSecuredRoute() {
        return this.securedRoute;
    }
}

