/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.mvc;

import com.auth0.spring.security.mvc.Auth0JWTToken;
import com.auth0.web.SessionUtils;
import com.auth0.web.Tokens;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.GenericFilterBean;

public class Auth0AuthenticationFilter
extends GenericFilterBean {
    @Autowired
    private AuthenticationManager authenticationManager;
    private AuthenticationEntryPoint entryPoint;

    protected boolean tokensExist(Tokens tokens) {
        if (tokens == null) {
            return false;
        }
        return tokens.getIdToken() != null && tokens.getAccessToken() != null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getMethod().equals("OPTIONS")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Tokens tokens = SessionUtils.getTokens((HttpServletRequest)request);
        if (this.tokensExist(tokens)) {
            try {
                String jwt = tokens.getIdToken();
                Auth0JWTToken token = new Auth0JWTToken(jwt);
                Authentication authResult = this.authenticationManager.authenticate((Authentication)token);
                SecurityContextHolder.getContext().setAuthentication(authResult);
            }
            catch (AuthenticationException failed) {
                SecurityContextHolder.clearContext();
                this.entryPoint.commence(request, response, failed);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public AuthenticationEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(AuthenticationEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }
}

