/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.mvc;

import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.JWTVerifyException;
import com.auth0.spring.security.mvc.Auth0AuthorityStrategy;
import com.auth0.spring.security.mvc.Auth0JWTToken;
import com.auth0.spring.security.mvc.Auth0TokenException;
import com.auth0.spring.security.mvc.Auth0UserDetails;
import com.auth0.web.Auth0User;
import com.auth0.web.SessionUtils;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class Auth0AuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final AuthenticationException AUTH_ERROR = new Auth0TokenException("Authentication Error");
    private JWTVerifier jwtVerifier;
    private String domain;
    private String issuer;
    private String clientId;
    private String clientSecret;
    private String securedRoute;
    private boolean base64EncodedSecret;
    private Auth0AuthorityStrategy authorityStrategy;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            String token = ((Auth0JWTToken)authentication).getJwt();
            this.logger.info((Object)("Trying to authenticate with token: " + token));
            Auth0JWTToken tokenAuth = (Auth0JWTToken)authentication;
            Map decoded = this.jwtVerifier.verify(token);
            this.logger.debug((Object)("Decoded JWT token" + decoded));
            tokenAuth.setAuthenticated(true);
            ServletRequestAttributes servletReqAttr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest req = servletReqAttr.getRequest();
            Auth0User auth0User = SessionUtils.getAuth0User((HttpServletRequest)req);
            Validate.notNull((Object)auth0User);
            tokenAuth.setPrincipal(new Auth0UserDetails(auth0User, this.authorityStrategy));
            tokenAuth.setDetails(decoded);
            return authentication;
        }
        catch (InvalidKeyException e) {
            this.logger.debug((Object)("InvalidKeyException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.debug((Object)("NoSuchAlgorithmException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (IllegalStateException e) {
            this.logger.debug((Object)("IllegalStateException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (SignatureException e) {
            this.logger.debug((Object)("SignatureException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (IOException e) {
            this.logger.debug((Object)("IOException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
        catch (JWTVerifyException e) {
            this.logger.debug((Object)("JWTVerifyException thrown while decoding JWT token " + e.getLocalizedMessage()));
            throw AUTH_ERROR;
        }
    }

    public boolean supports(Class<?> authentication) {
        return Auth0JWTToken.class.isAssignableFrom(authentication);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.clientSecret == null || this.clientId == null) {
            throw new IllegalStateException("client secret and client id are not set for Auth0AuthenticationProvider");
        }
        if (this.securedRoute == null) {
            throw new IllegalStateException("You must set which route pattern is used to check for users so that they must be authenticated");
        }
        if (this.base64EncodedSecret) {
            new Base64(true);
            this.jwtVerifier = new JWTVerifier(Base64.decodeBase64((String)this.clientSecret), this.clientId, this.issuer);
        } else {
            this.jwtVerifier = new JWTVerifier(this.clientSecret, this.clientId, this.issuer);
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getSecuredRoute() {
        return this.securedRoute;
    }

    public void setSecuredRoute(String securedRoute) {
        this.securedRoute = securedRoute;
    }

    public boolean isBase64EncodedSecret() {
        return this.base64EncodedSecret;
    }

    public void setBase64EncodedSecret(boolean base64EncodedSecret) {
        this.base64EncodedSecret = base64EncodedSecret;
    }

    public Auth0AuthorityStrategy getAuthorityStrategy() {
        return this.authorityStrategy;
    }

    public void setAuthorityStrategy(Auth0AuthorityStrategy authorityStrategy) {
        this.authorityStrategy = authorityStrategy;
    }
}

