/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.mvc;

import com.auth0.Auth0Exception;
import com.auth0.jwt.JWTSigner;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.JWTVerifyException;
import com.auth0.spring.security.mvc.Auth0TokenHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class Auth0TokenHelperImpl
implements Auth0TokenHelper<Object>,
InitializingBean {
    private String clientSecret = null;
    private String clientId = null;

    @Override
    public String generateToken(Object object, long expiration) {
        Assert.isInstanceOf(Map.class, (Object)object, (String)"Claims object is not a java.util.Map");
        try {
            JWTSigner jwtSigner = new JWTSigner(Base64.decodeBase64((String)this.clientSecret));
            HashMap<String, Long> claims = new HashMap<String, Long>();
            claims.putAll((Map)object);
            claims.put("exp", expiration);
            String token = jwtSigner.sign(claims);
            return token;
        }
        catch (Exception e) {
            throw new Auth0Exception("Token generation error", (Throwable)e);
        }
    }

    @Override
    public Object decodeToken(String token) {
        new Base64(true);
        JWTVerifier jwtVerifier = new JWTVerifier(Base64.decodeBase64((String)this.clientSecret), this.clientId);
        try {
            Map verify = jwtVerifier.verify(token);
            String payload = (String)verify.get("$");
            Map map = (Map)new ObjectMapper().readValue(payload, Map.class);
            return map;
        }
        catch (InvalidKeyException e) {
            throw new Auth0Exception("InvalidKeyException during decodeToken operation", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Auth0Exception("NoSuchAlgorithmException during decodeToken operation", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new Auth0Exception("IllegalStateException during decodeToken operation", (Throwable)e);
        }
        catch (SignatureException e) {
            throw new Auth0Exception("SignatureException during decodeToken operation", (Throwable)e);
        }
        catch (IOException e) {
            throw new Auth0Exception("IOException during decodeToken operation", (Throwable)e);
        }
        catch (JWTVerifyException e) {
            throw new Auth0Exception("JWTVerifyException during decodeToken operation", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.clientSecret, (String)("The client secret is not set for " + this.getClass()));
        Assert.notNull((Object)this.clientId, (String)("The client id is not set for " + this.getClass()));
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

