/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.mvc;

import com.auth0.authentication.result.UserIdentity;
import com.auth0.spring.security.mvc.Auth0AuthorityStrategy;
import com.auth0.web.Auth0User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class Auth0UserDetails
implements UserDetails {
    private static final long serialVersionUID = 2058797193125711681L;
    private static final Logger logger = LoggerFactory.getLogger(Auth0UserDetails.class);
    private String userId;
    private String username;
    private String name;
    private String email;
    private boolean emailVerified;
    private String nickname;
    private String picture;
    private Map<String, Object> extraInfo;
    private List<UserIdentity> identities;
    private ArrayList<GrantedAuthority> authorities;

    public Auth0UserDetails(Auth0User auth0User, Auth0AuthorityStrategy authorityStrategy) {
        this.userId = auth0User.getUserId();
        this.username = auth0User.getEmail() != null ? auth0User.getEmail() : (auth0User.getUserId() != null ? auth0User.getUserId() : "UNKNOWN_USER");
        this.name = auth0User.getName();
        this.email = auth0User.getEmail();
        if (this.email != null) {
            this.emailVerified = auth0User.isEmailVerified();
        }
        this.nickname = auth0User.getNickname();
        this.picture = auth0User.getPicture();
        this.identities = auth0User.getIdentities();
        this.extraInfo = auth0User.getExtraInfo();
        this.setupGrantedAuthorities(auth0User, authorityStrategy);
    }

    private void setupGrantedAuthorities(Auth0User auth0User, Auth0AuthorityStrategy authorityStrategy) {
        this.authorities = new ArrayList();
        if (Auth0AuthorityStrategy.ROLES.equals((Object)authorityStrategy)) {
            if (auth0User.getRoles() != null) {
                logger.debug("Attempting to map Roles");
                try {
                    for (String role : auth0User.getRoles()) {
                        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    logger.error("Error setting up GrantedAuthority using Roles");
                }
            }
        } else if (Auth0AuthorityStrategy.GROUPS.equals((Object)authorityStrategy)) {
            if (auth0User.getGroups() != null) {
                logger.debug("Attempting to map Groups");
                try {
                    for (String group : auth0User.getGroups()) {
                        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(group));
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    logger.error("Error setting up GrantedAuthority using Groups");
                }
            }
        } else if (Auth0AuthorityStrategy.SCOPE.equals((Object)authorityStrategy)) {
            throw new IllegalStateException("SCOPE authority strategy currently not supported for MVC apps");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPicture() {
        return this.picture;
    }

    public List<UserIdentity> getIdentities() {
        return this.identities;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        throw new UnsupportedOperationException("Password is protected");
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return false;
    }

    public boolean isAccountNonLocked() {
        return false;
    }

    public boolean isCredentialsNonExpired() {
        return false;
    }

    public boolean isEnabled() {
        return this.emailVerified;
    }
}

