/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.mvc;

import com.auth0.Auth0Client;
import com.auth0.Auth0User;
import com.auth0.NonceUtils;
import com.auth0.SessionUtils;
import com.auth0.Tokens;
import com.auth0.spring.security.mvc.Auth0Config;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Auth0CallbackHandler {
    protected String redirectOnSuccess;
    protected String redirectOnFail;
    protected Auth0Config auth0Config;
    protected Auth0Client auth0Client;

    @Autowired
    protected void setAuth0Client(Auth0Client auth0Client) {
        this.auth0Client = auth0Client;
    }

    @Autowired
    protected void setAuth0Config(Auth0Config auth0Config) {
        this.auth0Config = auth0Config;
        this.redirectOnSuccess = auth0Config.getLoginRedirectOnSuccess();
        this.redirectOnFail = auth0Config.getLoginRedirectOnFail();
    }

    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            if (this.isValidRequest(req)) {
                Tokens tokens = this.fetchTokens(req);
                Auth0User auth0User = this.auth0Client.getUserProfile(tokens);
                this.store(tokens, auth0User, req);
                NonceUtils.removeNonceFromStorage((HttpServletRequest)req);
                this.onSuccess(req, res);
            } else {
                this.onFailure(req, res, new IllegalStateException("Invalid state or error"));
            }
        }
        catch (RuntimeException ex) {
            this.onFailure(req, res, ex);
        }
    }

    protected void onSuccess(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.sendRedirect(req.getContextPath() + this.redirectOnSuccess);
    }

    protected void onFailure(HttpServletRequest req, HttpServletResponse res, Exception e) throws ServletException, IOException {
        e.printStackTrace();
        String redirectOnFailLocation = req.getContextPath() + this.redirectOnFail;
        res.sendRedirect(redirectOnFailLocation);
    }

    protected void store(Tokens tokens, Auth0User user, HttpServletRequest req) {
        SessionUtils.setTokens((HttpServletRequest)req, (Tokens)tokens);
        SessionUtils.setAuth0User((HttpServletRequest)req, (Auth0User)user);
    }

    protected Tokens fetchTokens(HttpServletRequest req) {
        String authorizationCode = req.getParameter("code");
        String redirectUri = req.getRequestURL().toString();
        return this.auth0Client.getTokens(authorizationCode, redirectUri);
    }

    protected boolean isValidRequest(HttpServletRequest req) throws IOException {
        return !this.hasError(req) && this.isValidState(req);
    }

    protected boolean hasError(HttpServletRequest req) {
        return req.getParameter("error") != null;
    }

    protected boolean isValidState(HttpServletRequest req) {
        String stateFromRequest = req.getParameter("state");
        return NonceUtils.matchesNonceInStorage((HttpServletRequest)req, (String)stateFromRequest);
    }
}

