/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.mvc;

import com.auth0.Auth0AuthorityStrategy;
import com.auth0.Auth0User;
import com.auth0.authentication.result.UserIdentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class Auth0UserDetails
implements UserDetails {
    private static final long serialVersionUID = 2058797193125711681L;
    private String userId;
    private String username;
    private String name;
    private String email;
    private boolean emailVerified;
    private String nickname;
    private String picture;
    private Map<String, Object> extraInfo;
    private Map<String, Object> userMetadata;
    private List<UserIdentity> identities;
    private ArrayList<GrantedAuthority> authorities;

    public Auth0UserDetails(Auth0User auth0User, Auth0AuthorityStrategy authorityStrategy) {
        this.userId = auth0User.getUserId();
        this.username = auth0User.getEmail() != null ? auth0User.getEmail() : (auth0User.getUserId() != null ? auth0User.getUserId() : "UNKNOWN_USER");
        this.name = auth0User.getName();
        this.email = auth0User.getEmail();
        if (this.email != null) {
            this.emailVerified = auth0User.isEmailVerified();
        }
        this.nickname = auth0User.getNickname();
        this.picture = auth0User.getPicture();
        this.identities = auth0User.getIdentities();
        this.extraInfo = auth0User.getExtraInfo();
        this.userMetadata = auth0User.getUserMetadata();
        this.setupGrantedAuthorities(auth0User, authorityStrategy);
    }

    private void setupGrantedAuthorities(Auth0User auth0User, Auth0AuthorityStrategy authorityStrategy) {
        this.authorities = new ArrayList();
        if (Auth0AuthorityStrategy.ROLES.equals((Object)authorityStrategy)) {
            if (auth0User.getRoles() != null) {
                try {
                    for (String role : auth0User.getRoles()) {
                        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
        } else if (Auth0AuthorityStrategy.GROUPS.equals((Object)authorityStrategy)) {
            if (auth0User.getGroups() != null) {
                try {
                    for (String group : auth0User.getGroups()) {
                        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(group));
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
        } else if (Auth0AuthorityStrategy.SCOPE.equals((Object)authorityStrategy)) {
            throw new IllegalStateException("SCOPE authority strategy not supported for MVC apps");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPicture() {
        return this.picture;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public Map<String, Object> getExtraInfo() {
        return Collections.unmodifiableMap(this.extraInfo);
    }

    public List<UserIdentity> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public Map<String, Object> getUserMetadata() {
        return Collections.unmodifiableMap(this.userMetadata);
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.emailVerified;
    }
}

