/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.guardian;

import com.auth0.guardian.APIClient;
import com.auth0.guardian.Enrollment;
import com.auth0.guardian.EnrollmentType;
import com.auth0.guardian.GuardianException;
import com.auth0.guardian.StartFlowResponse;
import com.auth0.guardian.Transaction;
import java.io.IOException;
import okhttp3.HttpUrl;

public class Guardian {
    private final APIClient apiClient;

    public Guardian(String baseUrl) {
        HttpUrl url = HttpUrl.parse((String)baseUrl);
        if (url == null) {
            throw new IllegalArgumentException("Invalid base URL: " + baseUrl);
        }
        this.apiClient = new APIClient(url);
    }

    public Transaction requestEnroll(String ticket, EnrollmentType type) throws IOException, GuardianException {
        StartFlowResponse startFlowResponse = this.apiClient.startFlow(ticket).execute();
        if (!"confirmation_pending".equals(startFlowResponse.getDeviceAccount().getStatus())) {
            throw GuardianException.alreadyEnrolled();
        }
        if (type instanceof EnrollmentType.SMS) {
            EnrollmentType.SMS smsEnrollmentRequest = (EnrollmentType.SMS)type;
            this.apiClient.sendEnrollSMS(startFlowResponse.getTransactionToken(), startFlowResponse.getDeviceAccount().getId(), smsEnrollmentRequest.getPhoneNumber()).execute();
        }
        return new Transaction(startFlowResponse.getTransactionToken(), startFlowResponse.getDeviceAccount().getRecoveryCode(), startFlowResponse.getDeviceAccount().getOtpSecret());
    }

    public Enrollment confirmEnroll(Transaction transaction, String otp) throws IOException, IllegalArgumentException, GuardianException {
        if (transaction == null || transaction.getTransactionToken() == null) {
            throw new IllegalArgumentException("Invalid enrollment transaction");
        }
        if (otp == null) {
            throw new IllegalArgumentException("Invalid OTP");
        }
        this.apiClient.verifyOTP(transaction.getTransactionToken(), otp).execute();
        return new Enrollment(transaction.getRecoveryCode());
    }

    public void confirmEnroll(String transactionToken, String otp) throws IOException, IllegalArgumentException, GuardianException {
        if (transactionToken == null) {
            throw new IllegalArgumentException("Invalid enrollment transaction");
        }
        if (otp == null) {
            throw new IllegalArgumentException("Invalid OTP");
        }
        this.apiClient.verifyOTP(transactionToken, otp).execute();
    }
}

