/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.guardian;

import java.util.HashMap;
import java.util.Map;

public class GuardianException
extends RuntimeException {
    private static final String ERROR_INVALID_OTP = "invalid_otp";
    private static final String ERROR_INVALID_TOKEN = "invalid_token";
    private static final String ERROR_DEVICE_ACCOUNT_NOT_FOUND = "device_account_not_found";
    private static final String ERROR_ENROLLMENT_NOT_FOUND = "enrollment_not_found";
    private static final String ERROR_LOGIN_TRANSACTION_NOT_FOUND = "login_transaction_not_found";
    private static final String ERROR_TRANSACTION_NOT_FOUND = "transaction_not_found";
    private static final String ERROR_ALREADY_ENROLLED = "already_enrolled";
    private final Map<String, Object> errorResponse;
    private final String errorCode;

    public GuardianException(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
        this.errorCode = null;
        this.errorResponse = null;
    }

    public GuardianException(Map<String, Object> errorResponse) {
        super((String)errorResponse.get("error"));
        this.errorCode = (String)errorResponse.get("errorCode");
        this.errorResponse = errorResponse;
    }

    static GuardianException alreadyEnrolled() {
        HashMap<String, Object> error = new HashMap<String, Object>(2);
        error.put("error", "Account already has an enrollment");
        error.put("errorCode", ERROR_ALREADY_ENROLLED);
        return new GuardianException(error);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public boolean isInvalidOTP() {
        return ERROR_INVALID_OTP.equals(this.errorCode);
    }

    public boolean isInvalidToken() {
        return ERROR_INVALID_TOKEN.equals(this.errorCode);
    }

    public boolean isEnrollmentNotFound() {
        return ERROR_DEVICE_ACCOUNT_NOT_FOUND.equals(this.errorCode) || ERROR_ENROLLMENT_NOT_FOUND.equals(this.errorCode);
    }

    public boolean isLoginTransactionNotFound() {
        return ERROR_LOGIN_TRANSACTION_NOT_FOUND.equals(this.errorCode);
    }

    public boolean isTransactionNotFound() {
        return ERROR_TRANSACTION_NOT_FOUND.equals(this.errorCode);
    }

    public boolean isAlreadyEnrolled() {
        return ERROR_ALREADY_ENROLLED.equals(this.errorCode);
    }

    @Override
    public String toString() {
        if (this.errorResponse != null) {
            return "GuardianException{" + this.errorResponse + '}';
        }
        return super.toString();
    }
}

