/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.guardian;

import java.io.Serializable;
import okhttp3.HttpUrl;

public class Transaction
implements Serializable {
    private String transactionToken;
    private String recoveryCode;
    private transient String totpSecret;

    Transaction(String transactionToken, String recoveryCode, String totpSecret) {
        this.transactionToken = transactionToken;
        this.recoveryCode = recoveryCode;
        this.totpSecret = totpSecret;
    }

    public String getTransactionToken() {
        return this.transactionToken;
    }

    public String getRecoveryCode() {
        return this.recoveryCode;
    }

    public String getTotpSecret() throws IllegalStateException {
        if (this.totpSecret == null) {
            throw new IllegalStateException("There is no OTP Secret for this transaction");
        }
        return this.totpSecret;
    }

    public String totpURI(String user, String issuer) throws IllegalStateException {
        return new HttpUrl.Builder().scheme("https").host("totp").addPathSegment(String.format("%s:%s", issuer, user)).addQueryParameter("secret", this.getTotpSecret()).addQueryParameter("issuer", issuer).build().toString().replaceFirst("https", "otpauth");
    }
}

