/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.guardian.networking;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;

class JsonConverter {
    private final ObjectMapper mapper;

    JsonConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    byte[] serialize(Object body) throws IllegalArgumentException {
        try {
            return this.mapper.writeValueAsBytes(body);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Couldn't create request body for data: " + body, e);
        }
    }

    <T> T parse(Class<T> classOfT, Reader reader) throws IOException {
        return (T)this.mapper.readValue(reader, classOfT);
    }
}

