/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.guardian.networking;

import com.auth0.guardian.GuardianException;
import com.auth0.guardian.networking.JsonConverter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Request<T> {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private final JsonConverter converter;
    private final OkHttpClient client;
    private final Class<T> classOfT;
    private final HttpUrl url;
    private final String method;
    private Object body;
    private final Map<String, String> headers;
    private final Map<String, Object> bodyParameters;
    private final Map<String, String> queryParameters;

    Request(String method, HttpUrl url, JsonConverter converter, OkHttpClient client, Class<T> classOfT) {
        this.method = method;
        this.url = url;
        this.converter = converter;
        this.client = client;
        this.classOfT = classOfT;
        this.headers = new HashMap<String, String>();
        this.bodyParameters = new HashMap<String, Object>();
        this.queryParameters = new HashMap<String, String>();
    }

    public Request<T> setParameter(String name, Object value) throws IllegalArgumentException {
        if (this.body != null) {
            throw new IllegalArgumentException("Cannot set body and parameters at the same time");
        }
        if (value != null) {
            this.bodyParameters.put(name, value);
        } else {
            this.bodyParameters.remove(name);
        }
        return this;
    }

    public Request<T> setQueryParameter(String name, String value) {
        if (value != null) {
            this.queryParameters.put(name, value);
        } else {
            this.queryParameters.remove(name);
        }
        return this;
    }

    public Request<T> setHeader(String name, String value) {
        if (value != null) {
            this.headers.put(name, value);
        } else {
            this.headers.remove(name);
        }
        return this;
    }

    public Request<T> setBody(Object body) {
        this.body = body;
        return this;
    }

    public T execute() throws IOException {
        Response response = this.buildCall().execute();
        if (response.isSuccessful()) {
            return this.payloadFromResponse(response);
        }
        throw this.exceptionFromErrorResponse(response);
    }

    private Call buildCall() {
        HttpUrl.Builder urlBuilder = this.url.newBuilder();
        for (Map.Entry<String, String> entry : this.queryParameters.entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
        }
        Request.Builder requestBuilder = new Request.Builder().url(urlBuilder.build());
        RequestBody requestBody = null;
        if (this.body != null) {
            requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (byte[])this.converter.serialize(this.body));
        } else if (!this.bodyParameters.isEmpty()) {
            requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (byte[])this.converter.serialize(this.bodyParameters));
        }
        requestBuilder.method(this.method, requestBody);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        return this.client.newCall(requestBuilder.build());
    }

    private T payloadFromResponse(Response response) throws GuardianException {
        try {
            if (response.code() == 204 || Void.class.equals(this.classOfT)) {
                return null;
            }
            Reader reader = response.body().charStream();
            return this.converter.parse(this.classOfT, reader);
        }
        catch (Exception e) {
            throw new GuardianException("Error parsing server response", e);
        }
    }

    private GuardianException exceptionFromErrorResponse(Response response) {
        try {
            Reader reader = response.body().charStream();
            Map error = this.converter.parse(Map.class, reader);
            return new GuardianException(error);
        }
        catch (Exception e) {
            return new GuardianException("Error parsing server error response", e);
        }
    }
}

