/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class JWTVerifier {
    private final String secret;
    private final String audience;
    private final String issuer;
    private final Base64 decoder;
    private final ObjectMapper mapper;
    private Map<String, String> algorithms;

    public JWTVerifier(String secret, String audience, String issuer) {
        if (secret == null || "".equals(secret)) {
            throw new IllegalArgumentException("Secret cannot be null or empty");
        }
        this.decoder = new Base64(true);
        this.mapper = new ObjectMapper();
        this.algorithms = new HashMap<String, String>();
        this.algorithms.put("HS256", "HmacSHA256");
        this.algorithms.put("HS384", "HmacSHA384");
        this.algorithms.put("HS512", "HmacSHA512");
        this.secret = secret;
        this.audience = audience;
        this.issuer = issuer;
    }

    public JWTVerifier(String secret, String audience) {
        this(secret, audience, null);
    }

    public JWTVerifier(String secret) {
        this(secret, null, null);
    }

    public Map<String, Object> verify(String token) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IOException, SignatureException {
        if (token == null || "".equals(token)) {
            throw new IllegalStateException("token not set");
        }
        String[] pieces = token.split("\\.");
        if (pieces.length != 3) {
            throw new IllegalStateException("Wrong number of segments: " + pieces.length);
        }
        JsonNode jwtHeader = this.decodeAndParse(pieces[0]);
        String algorithm = this.getAlgorithm(jwtHeader);
        JsonNode jwtPayload = this.decodeAndParse(pieces[1]);
        this.verifySignature(pieces, algorithm);
        this.verifyExpiration(jwtPayload);
        this.verifyIssuer(jwtPayload);
        this.verifyAudience(jwtPayload);
        return (Map)this.mapper.treeToValue((TreeNode)jwtPayload, Map.class);
    }

    void verifySignature(String[] pieces, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Mac hmac = Mac.getInstance(algorithm);
        hmac.init(new SecretKeySpec(Base64.decodeBase64((String)this.secret), algorithm));
        byte[] sig = hmac.doFinal((pieces[0] + "." + pieces[1]).getBytes());
        if (!Arrays.equals(sig, Base64.decodeBase64((String)pieces[2]))) {
            throw new SignatureException("signature verification failed");
        }
    }

    void verifyExpiration(JsonNode jwtClaims) {
        long expiration;
        long l = expiration = jwtClaims.has("exp") ? jwtClaims.get("exp").asLong(0L) : 0L;
        if (expiration != 0L && System.currentTimeMillis() / 1000L >= expiration) {
            throw new IllegalStateException("jwt expired");
        }
    }

    void verifyIssuer(JsonNode jwtClaims) {
        String issuerFromToken;
        String string = issuerFromToken = jwtClaims.has("iss") ? jwtClaims.get("iss").asText() : null;
        if (issuerFromToken != null && this.issuer != null && !this.issuer.equals(issuerFromToken)) {
            throw new IllegalStateException("jwt issuer invalid");
        }
    }

    void verifyAudience(JsonNode jwtClaims) {
        String audienceFromToken;
        String string = audienceFromToken = jwtClaims.has("aud") ? jwtClaims.get("aud").asText() : null;
        if (audienceFromToken != null && !this.audience.equals(audienceFromToken)) {
            throw new IllegalStateException("jwt audience invalid");
        }
    }

    String getAlgorithm(JsonNode jwtHeader) {
        String algorithmName;
        String string = algorithmName = jwtHeader.has("alg") ? jwtHeader.get("alg").asText() : null;
        if (jwtHeader.get("alg") == null) {
            throw new IllegalStateException("algorithm not set");
        }
        if (this.algorithms.get(algorithmName) == null) {
            throw new IllegalStateException("unsupported algorithm");
        }
        return this.algorithms.get(algorithmName);
    }

    JsonNode decodeAndParse(String b64String) throws IOException {
        String jsonString = new String(Base64.decodeBase64((String)b64String), "UTF-8");
        JsonNode jwtHeader = (JsonNode)this.mapper.readValue(jsonString, JsonNode.class);
        return jwtHeader;
    }
}

