/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.ClaimSet;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.codec.binary.Base64;

public class JwtSigner {
    public String encode(Algorithm algorithm, String payload, String payloadId, String key, ClaimSet claimSet) throws Exception {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(this.encodedHeader(algorithm));
        segments.add(this.encodedPayload(payload, payloadId, claimSet));
        segments.add(this.encodedSignature(this.join(segments, "."), key, algorithm));
        return this.join(segments, ".");
    }

    private String encodedHeader(Algorithm algorithm) throws Exception {
        if (algorithm == null) {
            algorithm = Algorithm.HS256;
        }
        ObjectNode header = JsonNodeFactory.instance.objectNode();
        header.put("type", "JWT");
        header.put("alg", algorithm.name());
        return this.base64UrlEncode(header.toString().getBytes());
    }

    private String encodedPayload(String payload, String payloadId, ClaimSet claimSet) throws Exception {
        ObjectNode localClaimSet = JsonNodeFactory.instance.objectNode();
        ObjectNode localPayload = JsonNodeFactory.instance.objectNode();
        localPayload.put(payloadId, payload);
        if (claimSet != null) {
            if (claimSet.getExp() > 0) {
                localClaimSet.put("exp", claimSet.getExp());
            }
            localPayload.putAll(localClaimSet);
        }
        return this.base64UrlEncode(localPayload.toString().getBytes());
    }

    private String encodedSignature(String signingInput, String key, Algorithm algorithm) throws Exception {
        byte[] signature = this.sign(algorithm, signingInput, key);
        return this.base64UrlEncode(signature);
    }

    private String base64UrlEncode(byte[] str) throws Exception {
        return new String(Base64.encodeBase64URLSafe((byte[])str));
    }

    private byte[] sign(Algorithm algorithm, String msg, String key) throws Exception {
        switch (algorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                return this.signHmac(algorithm, msg, key);
            }
        }
        throw new OperationNotSupportedException("Unsupported signing method");
    }

    private byte[] signHmac(Algorithm algorithm, String msg, String key) throws Exception {
        Mac mac = Mac.getInstance(algorithm.getValue());
        mac.init(new SecretKeySpec(key.getBytes(), algorithm.getValue()));
        return mac.doFinal(msg.getBytes());
    }

    private String join(List<String> input, String on) {
        int size = input.size();
        int count = 1;
        StringBuilder joined = new StringBuilder();
        for (String string : input) {
            joined.append(string);
            if (count < size) {
                joined.append(on);
            }
            ++count;
        }
        return joined.toString();
    }
}

