/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.ClaimSet;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.JwtProxy;
import com.auth0.jwt.JwtSigner;
import com.auth0.jwt.PayloadHandler;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class JwtProxyImpl
implements JwtProxy {
    private static final String PAYLOAD_ID = "payload";
    private PayloadHandler payloadHandler;

    @Override
    public void setPayloadHandler(PayloadHandler payloadHandler) {
        this.payloadHandler = payloadHandler;
    }

    public PayloadHandler getPayloadHandler() {
        return this.payloadHandler;
    }

    @Override
    public String encode(Algorithm algorithm, Object obj, String secret, ClaimSet claimSet) throws Exception {
        JwtSigner jwtSigner = new JwtSigner();
        String payload = this.getPayloadHandler().encoding(obj);
        return jwtSigner.encode(algorithm, payload, PAYLOAD_ID, secret, claimSet);
    }

    @Override
    public Object decode(Algorithm algorithm, String token, String secret) throws Exception {
        JWTVerifier jwtVerifier = new JWTVerifier(Base64.encodeBase64String((byte[])secret.getBytes()));
        Map<String, Object> verify = jwtVerifier.verify(token);
        String payload = (String)verify.get(PAYLOAD_ID);
        return this.getPayloadHandler().decoding(payload);
    }
}

