/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.impl;

import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BeanPropertyMap
implements Iterable<SettableBeanProperty> {
    private final Bucket[] _buckets;
    private final int _hashMask;
    private final int _size;

    public BeanPropertyMap(Collection<SettableBeanProperty> properties) {
        this._size = properties.size();
        int bucketCount = BeanPropertyMap.findSize(this._size);
        this._hashMask = bucketCount - 1;
        Bucket[] buckets = new Bucket[bucketCount];
        for (SettableBeanProperty property : properties) {
            String key = property.getName();
            int index = key.hashCode() & this._hashMask;
            buckets[index] = new Bucket(buckets[index], key, property);
        }
        this._buckets = buckets;
    }

    private BeanPropertyMap(Bucket[] buckets, int size) {
        this._buckets = buckets;
        this._size = size;
        this._hashMask = buckets.length - 1;
    }

    public BeanPropertyMap withProperty(SettableBeanProperty newProperty) {
        int bcount = this._buckets.length;
        Bucket[] newBuckets = new Bucket[bcount];
        System.arraycopy(this._buckets, 0, newBuckets, 0, bcount);
        String propName = newProperty.getName();
        SettableBeanProperty oldProp = this.find(newProperty.getName());
        if (oldProp == null) {
            int index = propName.hashCode() & this._hashMask;
            newBuckets[index] = new Bucket(newBuckets[index], propName, newProperty);
            return new BeanPropertyMap(newBuckets, this._size + 1);
        }
        BeanPropertyMap newMap = new BeanPropertyMap(newBuckets, bcount);
        newMap.replace(newProperty);
        return newMap;
    }

    public BeanPropertyMap renameAll(NameTransformer transformer) {
        if (transformer == null || transformer == NameTransformer.NOP) {
            return this;
        }
        Iterator<SettableBeanProperty> it = this.iterator();
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>();
        while (it.hasNext()) {
            JsonDeserializer<Object> newDeser;
            SettableBeanProperty prop = it.next();
            String newName = transformer.transform(prop.getName());
            JsonDeserializer<Object> deser = (prop = prop.withName(newName)).getValueDeserializer();
            if (deser != null && (newDeser = deser.unwrappingDeserializer(transformer)) != deser) {
                prop = prop.withValueDeserializer(newDeser);
            }
            newProps.add(prop);
        }
        return new BeanPropertyMap(newProps);
    }

    public BeanPropertyMap assignIndexes() {
        int index = 0;
        for (Bucket bucket : this._buckets) {
            while (bucket != null) {
                bucket.value.assignIndex(index++);
                bucket = bucket.next;
            }
        }
        return this;
    }

    private static final int findSize(int size) {
        int result;
        int needed = size <= 32 ? size + size : size + (size >> 2);
        for (result = 2; result < needed; result += result) {
        }
        return result;
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return new IteratorImpl(this._buckets);
    }

    public int size() {
        return this._size;
    }

    public SettableBeanProperty find(String key) {
        int index = key.hashCode() & this._hashMask;
        Bucket bucket = this._buckets[index];
        if (bucket == null) {
            return null;
        }
        if (bucket.key == key) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (bucket.key != key) continue;
            return bucket.value;
        }
        return this._findWithEquals(key, index);
    }

    public void replace(SettableBeanProperty property) {
        String name = property.getName();
        int index = name.hashCode() & this._buckets.length - 1;
        Bucket tail = null;
        boolean found = false;
        Bucket bucket = this._buckets[index];
        while (bucket != null) {
            if (!found && bucket.key.equals(name)) {
                found = true;
            } else {
                tail = new Bucket(tail, bucket.key, bucket.value);
            }
            bucket = bucket.next;
        }
        if (!found) {
            throw new NoSuchElementException("No entry '" + property + "' found, can't replace");
        }
        this._buckets[index] = new Bucket(tail, name, property);
    }

    public void remove(SettableBeanProperty property) {
        String name = property.getName();
        int index = name.hashCode() & this._buckets.length - 1;
        Bucket tail = null;
        boolean found = false;
        Bucket bucket = this._buckets[index];
        while (bucket != null) {
            if (!found && bucket.key.equals(name)) {
                found = true;
            } else {
                tail = new Bucket(tail, bucket.key, bucket.value);
            }
            bucket = bucket.next;
        }
        if (!found) {
            throw new NoSuchElementException("No entry '" + property + "' found, can't remove");
        }
        this._buckets[index] = tail;
    }

    private SettableBeanProperty _findWithEquals(String key, int index) {
        Bucket bucket = this._buckets[index];
        while (bucket != null) {
            if (key.equals(bucket.key)) {
                return bucket.value;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private static final class IteratorImpl
    implements Iterator<SettableBeanProperty> {
        private final Bucket[] _buckets;
        private Bucket _currentBucket;
        private int _nextBucketIndex;

        public IteratorImpl(Bucket[] buckets) {
            this._buckets = buckets;
            int i = 0;
            int len = this._buckets.length;
            while (i < len) {
                Bucket b;
                if ((b = this._buckets[i++]) == null) continue;
                this._currentBucket = b;
                break;
            }
            this._nextBucketIndex = i;
        }

        @Override
        public boolean hasNext() {
            return this._currentBucket != null;
        }

        @Override
        public SettableBeanProperty next() {
            Bucket curr = this._currentBucket;
            if (curr == null) {
                throw new NoSuchElementException();
            }
            Bucket b = curr.next;
            while (b == null && this._nextBucketIndex < this._buckets.length) {
                b = this._buckets[this._nextBucketIndex++];
            }
            this._currentBucket = b;
            return curr.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Bucket {
        public final Bucket next;
        public final String key;
        public final SettableBeanProperty value;

        public Bucket(Bucket next, String key, SettableBeanProperty value) {
            this.next = next;
            this.key = key;
            this.value = value;
        }
    }
}

