/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.impl;

import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonParser;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.DeserializationContext;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonMappingException;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public final class PropertyBasedCreator {
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _properties;
    protected final Object[] _defaultValues;
    protected final SettableBeanProperty[] _propertiesWithInjectables;

    protected PropertyBasedCreator(ValueInstantiator valueInstantiator, SettableBeanProperty[] creatorProps, Object[] defaultValues) {
        this._valueInstantiator = valueInstantiator;
        this._properties = new HashMap();
        SettableBeanProperty[] propertiesWithInjectables = null;
        int len = creatorProps.length;
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty prop = creatorProps[i];
            this._properties.put(prop.getName(), prop);
            Object injectableValueId = prop.getInjectableValueId();
            if (injectableValueId == null) continue;
            if (propertiesWithInjectables == null) {
                propertiesWithInjectables = new SettableBeanProperty[len];
            }
            propertiesWithInjectables[i] = prop;
        }
        this._defaultValues = defaultValues;
        this._propertiesWithInjectables = propertiesWithInjectables;
    }

    public static PropertyBasedCreator construct(DeserializationContext ctxt, ValueInstantiator valueInstantiator, SettableBeanProperty[] srcProps) throws JsonMappingException {
        int len = srcProps.length;
        SettableBeanProperty[] creatorProps = new SettableBeanProperty[len];
        Object[] defaultValues = null;
        for (int i = 0; i < len; ++i) {
            Object nullValue;
            SettableBeanProperty prop = srcProps[i];
            if (!prop.hasValueDeserializer()) {
                prop = prop.withValueDeserializer(ctxt.findContextualValueDeserializer(prop.getType(), prop));
            }
            creatorProps[i] = prop;
            JsonDeserializer<Object> deser = prop.getValueDeserializer();
            Object object = nullValue = deser == null ? null : deser.getNullValue();
            if (nullValue == null && prop.getType().isPrimitive()) {
                nullValue = ClassUtil.defaultValue(prop.getType().getRawClass());
            }
            if (nullValue == null) continue;
            if (defaultValues == null) {
                defaultValues = new Object[len];
            }
            defaultValues[i] = nullValue;
        }
        return new PropertyBasedCreator(valueInstantiator, creatorProps, defaultValues);
    }

    public void assignDeserializer(SettableBeanProperty prop, JsonDeserializer<Object> deser) {
        prop = prop.withValueDeserializer(deser);
        this._properties.put(prop.getName(), prop);
    }

    public Collection<SettableBeanProperty> properties() {
        return this._properties.values();
    }

    public SettableBeanProperty findCreatorProperty(String name) {
        return this._properties.get(name);
    }

    public PropertyValueBuffer startBuilding(JsonParser jp, DeserializationContext ctxt) {
        PropertyValueBuffer buffer = new PropertyValueBuffer(jp, ctxt, this._properties.size());
        if (this._propertiesWithInjectables != null) {
            buffer.inject(this._propertiesWithInjectables);
        }
        return buffer;
    }

    public Object build(DeserializationContext ctxt, PropertyValueBuffer buffer) throws IOException {
        Object bean = this._valueInstantiator.createFromObjectWith(ctxt, buffer.getParameters(this._defaultValues));
        PropertyValue pv = buffer.buffered();
        while (pv != null) {
            pv.assign(bean);
            pv = pv.next;
        }
        return bean;
    }
}

