/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.std;

import com.auth0.jwt.internal.com.fasterxml.jackson.core.Base64Variants;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonParser;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonProcessingException;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonToken;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.BeanProperty;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.DeserializationContext;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JavaType;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonMappingException;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.std.ClassDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class JdkDeserializers {
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{new StringDeserializer(), new UUIDDeserializer(), new URLDeserializer(), new URIDeserializer(), new CurrencyDeserializer(), new PatternDeserializer(), new LocaleDeserializer(), new InetAddressDeserializer(), new CharsetDeserializer(), new AtomicBooleanDeserializer(), new ClassDeserializer(), new StackTraceElementDeserializer()};
    }

    public static class StackTraceElementDeserializer
    extends StdScalarDeserializer<StackTraceElement> {
        public StackTraceElementDeserializer() {
            super(StackTraceElement.class);
        }

        @Override
        public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.START_OBJECT) {
                String className = "";
                String methodName = "";
                String fileName = "";
                int lineNumber = -1;
                while ((t = jp.nextValue()) != JsonToken.END_OBJECT) {
                    String propName = jp.getCurrentName();
                    if ("className".equals(propName)) {
                        className = jp.getText();
                        continue;
                    }
                    if ("fileName".equals(propName)) {
                        fileName = jp.getText();
                        continue;
                    }
                    if ("lineNumber".equals(propName)) {
                        if (t.isNumeric()) {
                            lineNumber = jp.getIntValue();
                            continue;
                        }
                        throw JsonMappingException.from(jp, "Non-numeric token (" + (Object)((Object)t) + ") for property 'lineNumber'");
                    }
                    if ("methodName".equals(propName)) {
                        methodName = jp.getText();
                        continue;
                    }
                    if ("nativeMethod".equals(propName)) continue;
                    this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
                }
                return new StackTraceElement(className, methodName, fileName, lineNumber);
            }
            throw ctxt.mappingException(this._valueClass, t);
        }
    }

    public static class AtomicBooleanDeserializer
    extends StdScalarDeserializer<AtomicBoolean> {
        public AtomicBooleanDeserializer() {
            super(AtomicBoolean.class);
        }

        @Override
        public AtomicBoolean deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new AtomicBoolean(this._parseBooleanPrimitive(jp, ctxt));
        }
    }

    public static class AtomicReferenceDeserializer
    extends StdScalarDeserializer<AtomicReference<?>>
    implements ContextualDeserializer {
        protected final JavaType _referencedType;
        protected final JsonDeserializer<?> _valueDeserializer;

        public AtomicReferenceDeserializer(JavaType referencedType) {
            this(referencedType, null);
        }

        public AtomicReferenceDeserializer(JavaType referencedType, JsonDeserializer<?> deser) {
            super(AtomicReference.class);
            this._referencedType = referencedType;
            this._valueDeserializer = deser;
        }

        @Override
        public AtomicReference<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new AtomicReference(this._valueDeserializer.deserialize(jp, ctxt));
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JsonDeserializer<?> deser = this._valueDeserializer;
            if (deser != null) {
                return this;
            }
            return new AtomicReferenceDeserializer(this._referencedType, ctxt.findContextualValueDeserializer(this._referencedType, property));
        }
    }

    protected static class CharsetDeserializer
    extends FromStringDeserializer<Charset> {
        public CharsetDeserializer() {
            super(Charset.class);
        }

        @Override
        protected Charset _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return Charset.forName(value);
        }
    }

    protected static class InetAddressDeserializer
    extends FromStringDeserializer<InetAddress> {
        public InetAddressDeserializer() {
            super(InetAddress.class);
        }

        @Override
        protected InetAddress _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return InetAddress.getByName(value);
        }
    }

    protected static class LocaleDeserializer
    extends FromStringDeserializer<Locale> {
        public LocaleDeserializer() {
            super(Locale.class);
        }

        @Override
        protected Locale _deserialize(String value, DeserializationContext ctxt) throws IOException {
            int ix = value.indexOf(95);
            if (ix < 0) {
                return new Locale(value);
            }
            String first = value.substring(0, ix);
            if ((ix = (value = value.substring(ix + 1)).indexOf(95)) < 0) {
                return new Locale(first, value);
            }
            String second = value.substring(0, ix);
            return new Locale(first, second, value.substring(ix + 1));
        }
    }

    public static class PatternDeserializer
    extends FromStringDeserializer<Pattern> {
        public PatternDeserializer() {
            super(Pattern.class);
        }

        @Override
        protected Pattern _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return Pattern.compile(value);
        }
    }

    public static class CurrencyDeserializer
    extends FromStringDeserializer<Currency> {
        public CurrencyDeserializer() {
            super(Currency.class);
        }

        @Override
        protected Currency _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return Currency.getInstance(value);
        }
    }

    public static class URIDeserializer
    extends FromStringDeserializer<URI> {
        public URIDeserializer() {
            super(URI.class);
        }

        @Override
        protected URI _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return URI.create(value);
        }
    }

    public static class URLDeserializer
    extends FromStringDeserializer<URL> {
        public URLDeserializer() {
            super(URL.class);
        }

        @Override
        protected URL _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return new URL(value);
        }
    }

    public static class UUIDDeserializer
    extends FromStringDeserializer<UUID> {
        public UUIDDeserializer() {
            super(UUID.class);
        }

        @Override
        protected UUID _deserialize(String value, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return UUID.fromString(value);
        }

        @Override
        protected UUID _deserializeEmbedded(Object ob, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (ob instanceof byte[]) {
                byte[] bytes = (byte[])ob;
                if (bytes.length != 16) {
                    ctxt.mappingException("Can only construct UUIDs from 16 byte arrays; got " + bytes.length + " bytes");
                }
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
                long l1 = in.readLong();
                long l2 = in.readLong();
                return new UUID(l1, l2);
            }
            super._deserializeEmbedded(ob, ctxt);
            return null;
        }
    }

    @JacksonStdImpl
    public static final class StringDeserializer
    extends StdScalarDeserializer<String> {
        public StringDeserializer() {
            super(String.class);
        }

        @Override
        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken curr = jp.getCurrentToken();
            if (curr == JsonToken.VALUE_STRING) {
                return jp.getText();
            }
            if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
                Object ob = jp.getEmbeddedObject();
                if (ob == null) {
                    return null;
                }
                if (ob instanceof byte[]) {
                    return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
                }
                return ob.toString();
            }
            if (curr.isScalarValue()) {
                return jp.getText();
            }
            throw ctxt.mappingException(this._valueClass, curr);
        }

        @Override
        public String deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
            return this.deserialize(jp, ctxt);
        }
    }
}

