/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.com.fasterxml.jackson.databind.ser.std;

import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonGenerationException;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonGenerator;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JavaType;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonMappingException;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonNode;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JsonSerializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.SerializationFeature;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.SerializerProvider;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public abstract class StdSerializer<T>
extends JsonSerializer<T>
implements SchemaAware {
    protected final Class<T> _handledType;

    protected StdSerializer(Class<T> t) {
        this._handledType = t;
    }

    protected StdSerializer(JavaType type) {
        this._handledType = type.getRawClass();
    }

    protected StdSerializer(Class<?> t, boolean dummy) {
        this._handledType = t;
    }

    @Override
    public final Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    protected ObjectNode createObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected ObjectNode createSchemaNode(String type) {
        ObjectNode schema = this.createObjectNode();
        schema.put("type", type);
        return schema;
    }

    protected ObjectNode createSchemaNode(String type, boolean isOptional) {
        ObjectNode schema = this.createSchemaNode(type);
        if (!isOptional) {
            schema.put("required", !isOptional);
        }
        return schema;
    }

    public void wrapAndThrow(SerializerProvider provider, Throwable t, Object bean, String fieldName) throws IOException {
        boolean wrap;
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        boolean bl = wrap = provider == null || provider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (t instanceof IOException) {
            if (!wrap || !(t instanceof JsonMappingException)) {
                throw (IOException)t;
            }
        } else if (!wrap && t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw JsonMappingException.wrapWithPath(t, bean, fieldName);
    }

    public void wrapAndThrow(SerializerProvider provider, Throwable t, Object bean, int index) throws IOException {
        boolean wrap;
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        boolean bl = wrap = provider == null || provider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (t instanceof IOException) {
            if (!wrap || !(t instanceof JsonMappingException)) {
                throw (IOException)t;
            }
        } else if (!wrap && t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw JsonMappingException.wrapWithPath(t, bean, index);
    }

    protected boolean isDefaultSerializer(JsonSerializer<?> serializer) {
        return serializer != null && serializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }
}

