/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.crypto.tls;

import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.AbstractTlsServer;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsCipher;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsCipherFactory;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsCredentials;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsKeyExchange;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsSRPIdentityManager;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsSRPLoginParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsSRPUtils;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsServer
extends AbstractTlsServer {
    protected TlsSRPIdentityManager srpIdentityManager;
    protected byte[] srpIdentity = null;
    protected TlsSRPLoginParameters loginParameters = null;

    public SRPTlsServer(TlsSRPIdentityManager tlsSRPIdentityManager) {
        this(new DefaultTlsCipherFactory(), tlsSRPIdentityManager);
    }

    public SRPTlsServer(TlsCipherFactory tlsCipherFactory, TlsSRPIdentityManager tlsSRPIdentityManager) {
        super(tlsCipherFactory);
        this.srpIdentityManager = tlsSRPIdentityManager;
    }

    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected int[] getCipherSuites() {
        return new int[]{49186, 49183, 49185, 49182, 49184, 49181};
    }

    public void processClientExtensions(Hashtable hashtable) throws IOException {
        super.processClientExtensions(hashtable);
        this.srpIdentity = TlsSRPUtils.getSRPExtension(hashtable);
    }

    public int getSelectedCipherSuite() throws IOException {
        int n = super.getSelectedCipherSuite();
        if (TlsSRPUtils.isSRPCipherSuite(n)) {
            if (this.srpIdentity != null) {
                this.loginParameters = this.srpIdentityManager.getLoginParameters(this.srpIdentity);
            }
            if (this.loginParameters == null) {
                throw new TlsFatalAlert(115);
            }
        }
        return n;
    }

    public TlsCredentials getCredentials() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return null;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.getDSASignerCredentials();
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.getRSASignerCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPKeyExchange(21);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPKeyExchange(23);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPKeyExchange(22);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49179: 
            case 49180: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 49181: 
            case 49182: 
            case 49183: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 49184: 
            case 49185: 
            case 49186: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n) {
        return new TlsSRPKeyExchange(n, this.supportedSignatureAlgorithms, this.srpIdentity, this.loginParameters);
    }
}

