/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.symmetric;

import com.auth0.jwt.internal.org.bouncycastle.crypto.CipherKeyGenerator;
import com.auth0.jwt.internal.org.bouncycastle.crypto.engines.Salsa20Engine;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Salsa20 {
    private Salsa20() {
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new Salsa20Engine(), 8);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Salsa20", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Salsa20.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.SALSA20", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.SALSA20", PREFIX + "$KeyGen");
        }
    }
}

