/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.algorithms;

import com.auth0.jwt.algorithms.ECDSAAlgorithm;
import com.auth0.jwt.algorithms.HMACAlgorithm;
import com.auth0.jwt.algorithms.NoneAlgorithm;
import com.auth0.jwt.algorithms.RSAAlgorithm;
import com.auth0.jwt.exceptions.SignatureGenerationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import java.io.UnsupportedEncodingException;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;

public abstract class Algorithm {
    private final String name;
    private final String description;

    public static Algorithm RSA256(RSAKey key) throws IllegalArgumentException {
        return new RSAAlgorithm("RS256", "SHA256withRSA", key);
    }

    public static Algorithm RSA384(RSAKey key) throws IllegalArgumentException {
        return new RSAAlgorithm("RS384", "SHA384withRSA", key);
    }

    public static Algorithm RSA512(RSAKey key) throws IllegalArgumentException {
        return new RSAAlgorithm("RS512", "SHA512withRSA", key);
    }

    public static Algorithm HMAC256(String secret) throws IllegalArgumentException, UnsupportedEncodingException {
        return new HMACAlgorithm("HS256", "HmacSHA256", secret);
    }

    public static Algorithm HMAC384(String secret) throws IllegalArgumentException, UnsupportedEncodingException {
        return new HMACAlgorithm("HS384", "HmacSHA384", secret);
    }

    public static Algorithm HMAC512(String secret) throws IllegalArgumentException, UnsupportedEncodingException {
        return new HMACAlgorithm("HS512", "HmacSHA512", secret);
    }

    public static Algorithm HMAC256(byte[] secret) throws IllegalArgumentException {
        return new HMACAlgorithm("HS256", "HmacSHA256", secret);
    }

    public static Algorithm HMAC384(byte[] secret) throws IllegalArgumentException {
        return new HMACAlgorithm("HS384", "HmacSHA384", secret);
    }

    public static Algorithm HMAC512(byte[] secret) throws IllegalArgumentException {
        return new HMACAlgorithm("HS512", "HmacSHA512", secret);
    }

    public static Algorithm ECDSA256(ECKey key) throws IllegalArgumentException {
        return new ECDSAAlgorithm("ES256", "SHA256withECDSA", 32, key);
    }

    public static Algorithm ECDSA384(ECKey key) throws IllegalArgumentException {
        return new ECDSAAlgorithm("ES384", "SHA384withECDSA", 48, key);
    }

    public static Algorithm ECDSA512(ECKey key) throws IllegalArgumentException {
        return new ECDSAAlgorithm("ES512", "SHA512withECDSA", 66, key);
    }

    public static Algorithm none() {
        return new NoneAlgorithm();
    }

    protected Algorithm(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public abstract void verify(byte[] var1, byte[] var2) throws SignatureVerificationException;

    public abstract byte[] sign(byte[] var1) throws SignatureGenerationException;
}

