/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.GuavaCachedJwkProvider;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.UrlJwkProvider;
import java.util.concurrent.TimeUnit;

public class JwkProviderBuilder {
    private String url;
    private TimeUnit expiresUnit = TimeUnit.HOURS;
    private long expiresIn = 10L;
    private long cacheSize = 5L;
    private boolean cached = true;

    public JwkProviderBuilder forDomain(String domain) {
        this.url = this.normalizeDomain(domain);
        return this;
    }

    public JwkProviderBuilder cached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public JwkProviderBuilder cached(long cacheSize, long expiresIn, TimeUnit unit) {
        this.cached = true;
        this.cacheSize = cacheSize;
        this.expiresIn = expiresIn;
        this.expiresUnit = unit;
        return this;
    }

    public JwkProvider build() {
        if (this.url == null) {
            throw new IllegalStateException("Cannot build provider without domain");
        }
        UrlJwkProvider urlProvider = new UrlJwkProvider(this.url);
        if (!this.cached) {
            return urlProvider;
        }
        return new GuavaCachedJwkProvider(urlProvider, this.cacheSize, this.expiresIn, this.expiresUnit);
    }

    private String normalizeDomain(String domain) {
        if (!domain.startsWith("http")) {
            return "https://" + domain;
        }
        return domain;
    }
}

