/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UrlJwkProvider
implements JwkProvider {
    final URL url;

    public UrlJwkProvider(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("A non-null url is required");
        }
        this.url = url;
    }

    public UrlJwkProvider(String domain) {
        if (Strings.isNullOrEmpty((String)domain)) {
            throw new IllegalArgumentException("A domain is required");
        }
        try {
            URL url = new URL(domain);
            this.url = new URL(url, "/.well-known/jwks.json");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid jwks uri", e);
        }
    }

    private Map<String, Object> getJwks() throws SigningKeyNotFoundException {
        try {
            InputStream inputStream = this.url.openStream();
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(inputStream);
            TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>(){};
            return (Map)new ObjectMapper().reader().readValue(parser, (TypeReference)typeReference);
        }
        catch (IOException e) {
            throw new SigningKeyNotFoundException("Cannot obtain jwks from url " + this.url.toString(), e);
        }
    }

    private List<Jwk> getAll() throws SigningKeyNotFoundException {
        ArrayList jwks = Lists.newArrayList();
        List keys = (List)this.getJwks().get("keys");
        if (keys == null || keys.isEmpty()) {
            throw new SigningKeyNotFoundException("No keys found in " + this.url.toString(), null);
        }
        try {
            for (Map values : keys) {
                jwks.add(Jwk.fromValues(values));
            }
        }
        catch (IllegalArgumentException e) {
            throw new SigningKeyNotFoundException("Failed to parse jwk from json", e);
        }
        return jwks;
    }

    @Override
    public Jwk get(String keyId) throws JwkException {
        List<Jwk> jwks = this.getAll();
        for (Jwk jwk : jwks) {
            if (!keyId.equals(jwk.getId())) continue;
            return jwk;
        }
        throw new SigningKeyNotFoundException("No key found in " + this.url.toString() + " with kid " + keyId, null);
    }
}

