/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.BucketImpl;
import com.auth0.jwk.GuavaCachedJwkProvider;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.RateLimitedJwkProvider;
import com.auth0.jwk.UrlJwkProvider;
import java.util.concurrent.TimeUnit;

public class JwkProviderBuilder {
    private final String url;
    private TimeUnit expiresUnit;
    private long expiresIn;
    private long cacheSize;
    private boolean cached;
    private BucketImpl bucket;
    private boolean rateLimited;

    public JwkProviderBuilder(String domain) {
        if (domain == null) {
            throw new IllegalStateException("Cannot build provider without domain");
        }
        this.url = this.normalizeDomain(domain);
        this.cached = true;
        this.expiresIn = 10L;
        this.expiresUnit = TimeUnit.HOURS;
        this.cacheSize = 5L;
        this.rateLimited = true;
        this.bucket = new BucketImpl(10L, 1L, TimeUnit.MINUTES);
    }

    public JwkProviderBuilder cached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public JwkProviderBuilder cached(long cacheSize, long expiresIn, TimeUnit unit) {
        this.cached = true;
        this.cacheSize = cacheSize;
        this.expiresIn = expiresIn;
        this.expiresUnit = unit;
        return this;
    }

    public JwkProviderBuilder rateLimited(boolean rateLimited) {
        this.rateLimited = rateLimited;
        return this;
    }

    public JwkProviderBuilder rateLimited(long bucketSize, long refillRate, TimeUnit unit) {
        this.bucket = new BucketImpl(bucketSize, refillRate, unit);
        return this;
    }

    public JwkProvider build() {
        JwkProvider urlProvider = new UrlJwkProvider(this.url);
        if (this.rateLimited) {
            urlProvider = new RateLimitedJwkProvider(urlProvider, this.bucket);
        }
        if (this.cached) {
            urlProvider = new GuavaCachedJwkProvider(urlProvider, this.cacheSize, this.expiresIn, this.expiresUnit);
        }
        return urlProvider;
    }

    private String normalizeDomain(String domain) {
        if (!domain.startsWith("http")) {
            return "https://" + domain;
        }
        return domain;
    }
}

