/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.InvalidRequestException;
import com.auth0.RandomStorage;
import com.auth0.RequestProcessor;
import com.auth0.SameSite;
import com.auth0.TransientCookieStore;
import com.auth0.client.auth.AuthAPI;
import com.auth0.client.auth.AuthorizeUrlBuilder;
import com.auth0.exception.Auth0Exception;
import com.auth0.json.auth.PushedAuthorizationResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthorizeUrl {
    private static final String SCOPE_OPENID = "openid";
    private HttpServletResponse response;
    private HttpServletRequest request;
    private final String responseType;
    private boolean useLegacySameSiteCookie = true;
    private boolean setSecureCookie = false;
    private String nonce;
    private String state;
    private final AuthAPI authAPI;
    private String cookiePath;
    private boolean used;
    private Map<String, String> params;
    private final String redirectUri;

    AuthorizeUrl(AuthAPI client, HttpServletRequest request, HttpServletResponse response, String redirectUri, String responseType) {
        this.request = request;
        this.response = response;
        this.responseType = responseType;
        this.authAPI = client;
        this.redirectUri = redirectUri;
        this.params = new HashMap<String, String>();
        this.params.put("scope", SCOPE_OPENID);
    }

    public AuthorizeUrl withOrganization(String organization) {
        this.params.put("organization", organization);
        return this;
    }

    public AuthorizeUrl withInvitation(String invitation) {
        this.params.put("invitation", invitation);
        return this;
    }

    public AuthorizeUrl withConnection(String connection) {
        this.params.put("connection", connection);
        return this;
    }

    public AuthorizeUrl withSecureCookie(boolean secureCookie) {
        this.setSecureCookie = secureCookie;
        return this;
    }

    AuthorizeUrl withLegacySameSiteCookie(boolean useLegacySameSiteCookie) {
        this.useLegacySameSiteCookie = useLegacySameSiteCookie;
        return this;
    }

    public AuthorizeUrl withAudience(String audience) {
        this.params.put("audience", audience);
        return this;
    }

    AuthorizeUrl withCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    public AuthorizeUrl withState(String state) {
        this.state = state;
        this.params.put("state", state);
        return this;
    }

    public AuthorizeUrl withNonce(String nonce) {
        this.nonce = nonce;
        this.params.put("nonce", nonce);
        return this;
    }

    public AuthorizeUrl withScope(String scope) {
        this.params.put("scope", scope);
        return this;
    }

    public AuthorizeUrl withParameter(String name, String value) {
        if ("state".equals(name) || "nonce".equals(name)) {
            throw new IllegalArgumentException("Please, use the dedicated methods for setting the 'nonce' and 'state' parameters.");
        }
        if ("response_type".equals(name)) {
            throw new IllegalArgumentException("Response type cannot be changed once set.");
        }
        if ("redirect_uri".equals(name)) {
            throw new IllegalArgumentException("Redirect URI cannot be changed once set.");
        }
        this.params.put(name, value);
        return this;
    }

    public String build() throws IllegalStateException {
        this.storeTransient();
        AuthorizeUrlBuilder builder = this.authAPI.authorizeUrl(this.redirectUri).withResponseType(this.responseType);
        this.params.forEach((arg_0, arg_1) -> ((AuthorizeUrlBuilder)builder).withParameter(arg_0, arg_1));
        return builder.build();
    }

    public String fromPushedAuthorizationRequest() throws InvalidRequestException {
        this.storeTransient();
        try {
            PushedAuthorizationResponse pushedAuthResponse = (PushedAuthorizationResponse)this.authAPI.pushedAuthorizationRequest(this.redirectUri, this.responseType, this.params).execute();
            String requestUri = pushedAuthResponse.getRequestURI();
            if (requestUri == null || requestUri.isEmpty()) {
                throw new InvalidRequestException("a0.api_error", "The PAR request returned a missing or empty request_uri value");
            }
            if (pushedAuthResponse.getExpiresIn() == null) {
                throw new InvalidRequestException("a0.api_error", "The PAR request returned a missing expires_in value");
            }
            return this.authAPI.authorizeUrlWithPAR(pushedAuthResponse.getRequestURI());
        }
        catch (Auth0Exception e) {
            throw new InvalidRequestException("a0.api_error", e.getMessage(), e);
        }
    }

    private void storeTransient() {
        if (this.used) {
            throw new IllegalStateException("The AuthorizeUrl instance must not be reused.");
        }
        if (this.response != null) {
            SameSite sameSiteValue = this.containsFormPost() ? SameSite.NONE : SameSite.LAX;
            TransientCookieStore.storeState(this.response, this.state, sameSiteValue, this.useLegacySameSiteCookie, this.setSecureCookie, this.cookiePath);
            TransientCookieStore.storeNonce(this.response, this.nonce, sameSiteValue, this.useLegacySameSiteCookie, this.setSecureCookie, this.cookiePath);
        }
        RandomStorage.setSessionState(this.request, this.state);
        RandomStorage.setSessionNonce(this.request, this.nonce);
        this.used = true;
    }

    private boolean containsFormPost() {
        String[] splitResponseTypes = this.responseType.trim().split("\\s+");
        List<String> responseTypes = Collections.unmodifiableList(Arrays.asList(splitResponseTypes));
        return RequestProcessor.requiresFormPostResponseMode(responseTypes);
    }
}

