/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.AuthCookie;
import com.auth0.SameSite;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;

class TransientCookieStore {
    private TransientCookieStore() {
    }

    static void storeState(HttpServletResponse response, String state, SameSite sameSite, boolean useLegacySameSiteCookie, boolean isSecureCookie, String cookiePath) {
        TransientCookieStore.store(response, "com.auth0.state", state, sameSite, useLegacySameSiteCookie, isSecureCookie, cookiePath);
    }

    static void storeNonce(HttpServletResponse response, String nonce, SameSite sameSite, boolean useLegacySameSiteCookie, boolean isSecureCookie, String cookiePath) {
        TransientCookieStore.store(response, "com.auth0.nonce", nonce, sameSite, useLegacySameSiteCookie, isSecureCookie, cookiePath);
    }

    static String getState(HttpServletRequest request, HttpServletResponse response) {
        return TransientCookieStore.getOnce("com.auth0.state", request, response);
    }

    static String getNonce(HttpServletRequest request, HttpServletResponse response) {
        return TransientCookieStore.getOnce("com.auth0.nonce", request, response);
    }

    private static void store(HttpServletResponse response, String key, String value, SameSite sameSite, boolean useLegacySameSiteCookie, boolean isSecureCookie, String cookiePath) {
        Validate.notNull((Object)response, (String)"response must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)key, (String)"key must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)sameSite), (String)"sameSite must not be null", (Object[])new Object[0]);
        if (value == null) {
            return;
        }
        boolean isSameSiteNone = SameSite.NONE == sameSite;
        AuthCookie sameSiteCookie = new AuthCookie(key, value);
        sameSiteCookie.setSameSite(sameSite);
        sameSiteCookie.setSecure(isSameSiteNone || isSecureCookie);
        if (cookiePath != null) {
            sameSiteCookie.setPath(cookiePath);
        }
        response.addHeader("Set-Cookie", sameSiteCookie.buildHeaderString());
        if (isSameSiteNone && useLegacySameSiteCookie) {
            AuthCookie legacyCookie = new AuthCookie("_" + key, value);
            legacyCookie.setSecure(isSecureCookie);
            response.addHeader("Set-Cookie", legacyCookie.buildHeaderString());
        }
    }

    private static String getOnce(String cookieName, HttpServletRequest request, HttpServletResponse response) {
        Cookie[] requestCookies = request.getCookies();
        if (requestCookies == null) {
            return null;
        }
        Cookie foundCookie = null;
        for (Cookie c : requestCookies) {
            if (!cookieName.equals(c.getName())) continue;
            foundCookie = c;
            break;
        }
        String foundCookieVal = null;
        if (foundCookie != null) {
            foundCookieVal = TransientCookieStore.decode(foundCookie.getValue());
            TransientCookieStore.delete(foundCookie, response);
        }
        Cookie foundLegacyCookie = null;
        for (Cookie c : requestCookies) {
            if (!("_" + cookieName).equals(c.getName())) continue;
            foundLegacyCookie = c;
            break;
        }
        String foundLegacyCookieVal = null;
        if (foundLegacyCookie != null) {
            foundLegacyCookieVal = TransientCookieStore.decode(foundLegacyCookie.getValue());
            TransientCookieStore.delete(foundLegacyCookie, response);
        }
        return foundCookieVal != null ? foundCookieVal : foundLegacyCookieVal;
    }

    private static void delete(Cookie cookie, HttpServletResponse response) {
        cookie.setMaxAge(0);
        cookie.setValue("");
        response.addCookie(cookie);
    }

    private static String decode(String valueToDecode) {
        try {
            return URLDecoder.decode(valueToDecode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 character set not supported", e.getCause());
        }
    }
}

