/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.SignatureVerifier;
import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

class AsymmetricSignatureVerifier
extends SignatureVerifier {
    AsymmetricSignatureVerifier(JwkProvider jwkProvider) {
        super(AsymmetricSignatureVerifier.createJWTVerifier(jwkProvider), "RS256");
    }

    private static JWTVerifier createJWTVerifier(final JwkProvider jwkProvider) {
        Algorithm alg = Algorithm.RSA256((RSAKeyProvider)new RSAKeyProvider(){

            public RSAPublicKey getPublicKeyById(String keyId) {
                try {
                    Jwk jwk = jwkProvider.get(keyId);
                    return (RSAPublicKey)jwk.getPublicKey();
                }
                catch (JwkException jwkException) {
                    return null;
                }
            }

            public RSAPrivateKey getPrivateKey() {
                return null;
            }

            public String getPrivateKeyId() {
                return null;
            }
        });
        return JWT.require((Algorithm)alg).ignoreIssuedAt().build();
    }
}

