/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORConstants;
import com.authlete.cbor.CBORNumber;
import com.authlete.cbor.CBORTaggedItem;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class CBORBigInteger
extends CBORNumber<BigInteger> {
    public CBORBigInteger(BigInteger value) {
        super(value);
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        boolean unsigned;
        BigInteger value = (BigInteger)this.getValue();
        boolean bl = unsigned = 0 <= value.signum();
        if (!unsigned) {
            value = CBORConstants.BIG_INTEGER_MINUS_ONE.subtract(value);
        }
        if (value.compareTo(CBORConstants.BIG_INTEGER_ULONG_MAX) <= 0) {
            this.encode(outputStream, unsigned, value);
        } else {
            this.encodeWithTag(outputStream, unsigned, value);
        }
    }

    private void encode(OutputStream outputStream, boolean unsigned, BigInteger value) throws IOException {
        int major = unsigned ? 0 : 1;
        this.encodeMajorWithNumber(outputStream, major, value);
    }

    private void encodeWithTag(OutputStream outputStream, boolean unsigned, BigInteger value) throws IOException {
        int tagNumber = unsigned ? 2 : 3;
        CBORByteArray tagContent = new CBORByteArray(value.toByteArray());
        CBORTaggedItem item = new CBORTaggedItem(tagNumber, tagContent);
        item.encode(outputStream);
    }
}

