/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORDecoder;
import com.authlete.cbor.CBORDecoderOptions;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CBORByteArray
extends CBORValue<byte[]> {
    private static final int TAG_ENCODED_CBOR_DATA_ITEM = 24;
    private static final CBORDecoderOptions DECODER_OPTIONS = new CBORDecoderOptions();
    private final List<? extends CBORItem> decodedContent;

    public CBORByteArray(byte[] value) {
        this(value, (CBORItem)null);
    }

    public CBORByteArray(byte[] value, CBORItem decodedContent) {
        this(value, decodedContent != null ? Arrays.asList(decodedContent) : null);
    }

    public CBORByteArray(byte[] value, List<? extends CBORItem> decodedContent) {
        super(value);
        this.decodedContent = decodedContent;
    }

    public List<? extends CBORItem> getDecodedContent() {
        return this.decodedContent;
    }

    @Override
    public String toString() {
        return this.toString(this.decodedContent != null);
    }

    @Override
    protected String toString(Number tagNumber) {
        if (CBORByteArray.isEncodedCborDataItem(tagNumber)) {
            return this.toString(true);
        }
        return this.toString(false);
    }

    private static boolean isEncodedCborDataItem(Number tagNumber) {
        if (tagNumber == null) {
            return false;
        }
        return tagNumber.intValue() == 24;
    }

    public String toString(boolean decode) {
        if (decode) {
            return this.buildDecodedString();
        }
        return this.buildString();
    }

    private String buildDecodedString() {
        List<? extends CBORItem> items = this.prepareDecodedContent();
        if (items != null) {
            return items.stream().map(Object::toString).collect(Collectors.joining(", ", "<<", ">>"));
        }
        return this.buildString();
    }

    private String buildString() {
        StringBuilder sb = new StringBuilder("h'");
        for (byte b : (byte[])this.getValue()) {
            sb.append(CBORByteArray.toHex(b));
        }
        sb.append("'");
        return sb.toString();
    }

    private static String toHex(int b) {
        return String.format("%02x", 0xFF & b);
    }

    @Override
    protected String prettify(String indent, String indentUnit, Number tagNumber) {
        String comment;
        String string = comment = this.getComment() == null ? "" : String.format("/ %s / ", this.getComment());
        if (CBORByteArray.isEncodedCborDataItem(tagNumber) || this.decodedContent != null) {
            return this.prettifyDecodedString(indent, indentUnit, comment);
        }
        return this.prettifyString(comment);
    }

    private String prettifyDecodedString(String indent, String indentUnit, String comment) {
        List<? extends CBORItem> items = this.prepareDecodedContent();
        if (items == null && this.getValue() != null) {
            return this.prettifyString(comment);
        }
        if (items == null || items.size() == 0) {
            return String.format("%s<<%n%s>>", comment, indent);
        }
        String delimiter = String.format(",%n", new Object[0]);
        String prefix = String.format("%s<<%n", comment);
        String suffix = String.format("%n%s>>", indent);
        String subIndent = indent + indentUnit;
        return items.stream().map(item -> String.format("%s%s", subIndent, item.prettify(subIndent, indentUnit, null))).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    private List<? extends CBORItem> prepareDecodedContent() {
        if (this.decodedContent != null) {
            return this.decodedContent;
        }
        if (this.getValue() == null) {
            return null;
        }
        try {
            return new CBORDecoder((byte[])this.getValue(), DECODER_OPTIONS).all();
        }
        catch (IOException cause) {
            return null;
        }
    }

    private String prettifyString(String comment) {
        return String.format("%s%s", comment, this.toString());
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        byte[] value = (byte[])this.getValue();
        this.encodeMajorWithNumber(outputStream, 2, value.length);
        outputStream.write(value);
    }
}

